package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.UndeadLinkDto;
import cn.com.duiba.tuia.ssp.center.api.dto.UndeadLinkListReq;
import cn.com.duiba.tuia.ssp.center.api.dto.WeChatDomainItemRsp;

import java.util.List;

/**
 * 微信小程序域名服务
 */
@AdvancedFeignClient
public interface RemoteUndeadLinkService {

    /**
     * 分页查询不死链接列表
     * @return
     */
    List<UndeadLinkDto> queryLinkList(UndeadLinkListReq undeadLinkListReq);


    List<UndeadLinkDto> selectAllLink(Integer status);

    UndeadLinkDto popOneLink();

    /**
     * 条目数
     * @return
     */
    int countLinkList(UndeadLinkListReq undeadLinkListReq);

    /**
     * 更改不死链接状态
     * @param linkId
     * @param status
     * @return
     */
    int updateLinkStatus(Long linkId,Integer status);

    /**
     * 新增不死链接
     * @param link
     * @return
     */
    int insertUndeadLink(String link,String sceneType);

    /**
     * 根据link链接查询记录
     * @param link
     * @return
     */
    UndeadLinkDto selectByLink(String link);


    UndeadLinkDto selectByPrimaryKey(Long id);


    int updateSelective(UndeadLinkDto undeadLinkDto);
}
