package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
@ApiModel
public class ReqUpdateBatchCheckStatus implements Serializable {

    private static final long serialVersionUID = -3722434258626536035L;

    @Valid
    @ApiModelProperty(value = "账单列表", required = true)
    @NotEmpty(message = "账单列表不能为空")
    private List<AppReport> reportList;

    @ApiModelProperty(value = "审核状态", required = true)
    @NotNull(message = "审核状态不能为空")
    private Integer status;

    @ApiModelProperty(value = "结算拒绝原因")
    private String rejectReason;

    @Data
    @ApiModel
    public static class AppReport {

        @ApiModelProperty(value = "月账单ID", required = true)
        @NotNull(message = "月账单ID不能为空")
        private Long reportId;

        @ApiModelProperty(value = "应用ID", required = true)
        @NotNull(message = "应用ID不能为空")
        private Long appId;

        @ApiModelProperty(value = "月账单日期", required = true)
        @NotNull(message = "月账单日期不能为空")
        private String currentDate;

        @ApiModelProperty(value = "生成日期")
        private String gmtCreate;

    }
}
