package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import java.util.List;

/**
 * @author shenjiaqing
 * @description 提问接口远程调用类
 * @data 2019/10/28
 */
@AdvancedFeignClient
public interface RemoteQuestionService {

    /**
     * 功能描述 删除提问
     * @author shenjiaqing
     * @date 13:34 2019/10/29
     * @param [questionId]
     * @return java.lang.Integer
     **/
    Integer deleteQuestion(Long questionId);

    /**
     * 功能描述 提交问题处理状态(已解决/未解决)
     * @author shenjiaqing
     * @date 13:34 2019/10/29
     * @param [questionId, disposeStatus]
     * @return java.lang.Integer
     **/
    Integer updateQuestionDisposeStatus(Long questionId,Integer disposeStatus);

    /**
     * 功能描述 查询问题是否已删除
     * @author shenjiaqing
     * @date 14:32 2019/11/1
     * @param [questionId]
     * @return java.lang.Integer
     **/
    Integer selectQuestionStatus(Long questionId);

    /**
     * 功能描述 获取提问列表-媒体人员
     * @author shenjiaqing
     * @date 13:35 2019/10/29
     * @param [mediaId]
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.QuestionToMediaDto>
     **/
    List<QuestionToMediaDto> getQuestionListToMedia(Long mediaId);

    /**
     * 功能描述 获取提问分类列表
     * @author shenjiaqing
     * @date 13:35 2019/10/29
     * @param []
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.QuestionCategoryDto>
     **/
    List<QuestionCategoryDto> getQuestionCategoryList();

    /**
     * 功能描述 获取提问列表-运营管理人员
     * @author shenjiaqing
     * @date 13:36 2019/10/29
     * @param [dto]
     * @return cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto<cn.com.duiba.tuia.ssp.center.api.dto.QuestionsDto>
     **/
    PageResultDto<QuestionsDto> getQuestionList(QuestionSearchDto dto);

    /**
     * 功能描述 获取提问详情
     * @author shenjiaqing
     * @date 17:36 2019/10/31
     * @param [questionId]
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.QuestionDetailDTO>
     **/
    QuestionDetailInfoDTO getQuestionDetails(Long questionId);

    /**
     * 功能描述 获取Top10常见问题
     * @author shenjiaqing
     * @date 13:36 2019/10/29
     * @param []
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.TopTenQuestionDto>
     **/
    List<TopTenQuestionDto> getTopTenQuestion();

    /**
     * 功能描述 提问
     * @author shenjiaqing
     * @date 13:36 2019/10/29
     * @param [req]
     * @return java.lang.Integer
     **/
    Integer askQuestion(QuestionDTO req);

    /**
     * 功能描述 回复问题
     * @author shenjiaqing
     * @date 13:42 2019/10/29
     * @param [req]
     * @return java.lang.Integer
     **/
    Integer answerQuestion(AnswerQuestionDTO req);

    /**
     * 功能描述 查询分类
     * @author shenjiaqing
     * @date 19:36 2019/10/29
     * @param [categoryId]
     * @return java.lang.String
     **/
    String selectCategoryNameById(Long categoryId);
}
