package cn.com.duiba.tuia.ssp.center.api.remote.advertselect;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.AdvertTagMapDto;
import cn.com.duiba.tuia.ssp.center.api.dto.advertselect.AdvertShileDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAdvertTagShieldStrategyService {

    List<AdvertShileDto> selectAdvertShieldList(Long id);

    int batchInvalidAdvertShield(Long advertId,String tagCode);

    /**
     * @Author zhangliwei
     * @Description  获取映射表List
     * @Date 10:02 2020-02-26
     * @Param []
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.AdvertTagMapDto>
     **/
    List<AdvertTagMapDto>  getMapList();

    /**
     * @Author zhangliwei
     * @Description 根据ID更新一级标签名称
     * @Date 10:05 2020-02-26
     * @Param [tagName, id]
     * @return boolean
     **/
    boolean updateLevel1Name(AdvertTagMapDto dto);

    /**
     * @Author zhangliwei
     * @Description 挪动二级标签
     * @Date 10:06 2020-02-26
     * @Param [id, targetId]
     * @return boolean
     **/
    boolean moveLevel2Tag(AdvertTagMapDto dto);


}
