package cn.com.duiba.tuia.ssp.center.api.dto.finaceData;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 媒体账户月报对象 tb_account_report_month_merge
 * 
 * @author liuyajun
 * @date 2022-02-11
 */
public class AccountReportMonthMergeDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 媒体用户id */
    private Long mediaId;

    /** 应用id */
    private Long appId;

    /** 广告位id */
    private Long slotId;

    /** 每月发券量 */
    private Long launchCount;

    /** 每月曝光数 */
    private Long exposureCount;

    /** 每月点击数 */
    private Long clickCount;

    /** 每月点击人数 */
    private Long clickCountUv;

    /** 每月消费(分) */
    private Long consumeTotal;

    /** 有效点击数 */
    private Long efClickCount;

    /** 月份 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date curDate;

    /** 结算状态：0-待结算，1-结算中，2-拒绝结算，3-已结算 */
    private Integer settlementStatus;

    /** 记录创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date gmtCreate;

    /** 记录修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date gmtModified;

    /** 月广告消耗 */
    private Long adConsume;

    /** 月媒体预计分成 */
    private Long exConsumeTotal;

    /** 提现单id,来源tb_media_cash_order.id */
    private Long cashOrderId;

    /** 提现状态: 0-待提现;1-审核中;2-提现拒绝;3-提现通过;4-已打款 */
    private Integer cashStatus;

    /** 入口曝光量 */
    private Long actExposeCount;

    /** 入口点击量 */
    private Long actClickCount;

    /** 广告位访问UV */
    private Long sdkUv;

    /** 活动广告券请求 */
    private Long advertRequestCount;

    /** 结算拒绝原因 */
    private String rejectReason;

    /** 媒体预计分成按分存储 */
    private Long mediaExDivide;

    /** 媒体应得分成按分存储 */
    private Long mediaDueDivide;

    /** 媒体请款清单状态：0:未请款，1:已请款 */
    private Integer cashRequirementStatus;

    /** 媒体运营 */
    private String mediaOperation;

    /** 风控运营 */
    private String riskControlOperation;

    /** 媒体运营结算时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date cashTime;

    /** 风控运营审核时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date auditTime;

    /** 杭州提现单id */
    private Long hzCashOrderId;

    /** 霍尔果斯提现单id */
    private Long hegsCashOrderId;

    /** 杭州提现状态 */
    private Long hzCashStatus;

    /** 霍尔果斯提现状态 */
    private Long hegsCashStatus;

    /** 杭州每日广告消耗(分) */
    private Long hzAdConsume;

    /** 霍尔果斯每日广告消耗(分) */
    private Long hegsAdConsume;

    /** 杭州每日媒体预计分成(分） */
    private Long hzExConsumeTotal;

    /** 霍尔果斯每日媒体预计分成(分） */
    private Long hegsExConsumeTotal;

    /** 杭州每日消费(分) */
    private Long hzConsumeTotal;

    /** 霍尔果斯每日消费(分) */
    private Long hegsConsumeTotal;

    /** 杭州媒体预计分成按分存储 */
    private Long hzMediaExDivide;

    /** 霍尔果斯媒体预计分成按分存储 */
    private Long hegsMediaExDivide;

    /** 杭州媒体应得分成按分存储 */
    private Long hzMediaDueDivide;

    /** 霍尔果斯媒体应得分成按分存储 */
    private Long hegsMediaDueDivide;

    /** 现金消耗(分) */
    private BigDecimal cashConsume;

    /** 杭州现金消耗(分) */
    private BigDecimal hzCashConsume;

    /** 霍尔果斯现金消耗(分) */
    private BigDecimal hegsCashConsume;

    /** 霍城兑捷提现单id */
    private Long hcdjCashOrderId;

    /** 霍城兑捷提现状态 */
    private Long hcdjCashStatus;

    /** 霍城兑捷每日广告消耗(分) */
    private Long hcdjAdConsume;

    /** 霍城兑捷每日媒体预计分成(分） */
    private Long hcdjExConsumeTotal;

    /** 霍城兑捷每日消费(分) */
    private Long hcdjConsumeTotal;

    /** 霍城兑捷媒体预计分成按分存储 */
    private Long hcdjMediaExDivide;

    /** 霍城兑捷媒体应得分成按分存储 */
    private Long hcdjMediaDueDivide;

    /** 霍城兑捷现金消耗(分) */
    private BigDecimal hcdjCashConsume;

    /** 杭州预结算单号 */
    private Long hzPreSettleOrderId;

    /** 霍尔果斯预结算单号 */
    private Long hegsPreSettleOrderId;

    /** 霍城兑捷预结算单id */
    private Long hcdjPreSettleOrderId;

    /** 杭州预结算状态 */
    private Long hzPreSettleStatus;

    /** 霍尔果斯预结算状态 */
    private Long hegsPreSettleStatus;

    /** 霍城兑捷预结算状态 */
    private Long hcdjPreSettleStatus;

    /**
     * 原有广告消耗（分）
     */
    private Long adConsumeOriginal;

    /**
     * 原有现金消耗(分)
     */
    private Long cashConsumeOriginal;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setMediaId(Long mediaId) 
    {
        this.mediaId = mediaId;
    }

    public Long getMediaId() 
    {
        return mediaId;
    }
    public void setAppId(Long appId) 
    {
        this.appId = appId;
    }

    public Long getAppId() 
    {
        return appId;
    }
    public void setSlotId(Long slotId) 
    {
        this.slotId = slotId;
    }

    public Long getSlotId() 
    {
        return slotId;
    }
    public void setLaunchCount(Long launchCount) 
    {
        this.launchCount = launchCount;
    }

    public Long getLaunchCount() 
    {
        return launchCount;
    }
    public void setExposureCount(Long exposureCount) 
    {
        this.exposureCount = exposureCount;
    }

    public Long getExposureCount() 
    {
        return exposureCount;
    }
    public void setClickCount(Long clickCount) 
    {
        this.clickCount = clickCount;
    }

    public Long getClickCount() 
    {
        return clickCount;
    }
    public void setClickCountUv(Long clickCountUv) 
    {
        this.clickCountUv = clickCountUv;
    }

    public Long getClickCountUv() 
    {
        return clickCountUv;
    }
    public void setConsumeTotal(Long consumeTotal) 
    {
        this.consumeTotal = consumeTotal;
    }

    public Long getConsumeTotal() 
    {
        return consumeTotal;
    }
    public void setEfClickCount(Long efClickCount) 
    {
        this.efClickCount = efClickCount;
    }

    public Long getEfClickCount() 
    {
        return efClickCount;
    }
    public void setCurDate(Date curDate) 
    {
        this.curDate = curDate;
    }

    public Date getCurDate() 
    {
        return curDate;
    }
    public void setSettlementStatus(Integer settlementStatus) 
    {
        this.settlementStatus = settlementStatus;
    }

    public Integer getSettlementStatus() 
    {
        return settlementStatus;
    }
    public void setGmtCreate(Date gmtCreate) 
    {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() 
    {
        return gmtCreate;
    }
    public void setGmtModified(Date gmtModified) 
    {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() 
    {
        return gmtModified;
    }
    public void setAdConsume(Long adConsume) 
    {
        this.adConsume = adConsume;
    }

    public Long getAdConsume() 
    {
        return adConsume;
    }
    public void setExConsumeTotal(Long exConsumeTotal) 
    {
        this.exConsumeTotal = exConsumeTotal;
    }

    public Long getExConsumeTotal() 
    {
        return exConsumeTotal;
    }
    public void setCashOrderId(Long cashOrderId) 
    {
        this.cashOrderId = cashOrderId;
    }

    public Long getCashOrderId() 
    {
        return cashOrderId;
    }
    public void setCashStatus(Integer cashStatus) 
    {
        this.cashStatus = cashStatus;
    }

    public Integer getCashStatus() 
    {
        return cashStatus;
    }
    public void setActExposeCount(Long actExposeCount) 
    {
        this.actExposeCount = actExposeCount;
    }

    public Long getActExposeCount() 
    {
        return actExposeCount;
    }
    public void setActClickCount(Long actClickCount) 
    {
        this.actClickCount = actClickCount;
    }

    public Long getActClickCount() 
    {
        return actClickCount;
    }
    public void setSdkUv(Long sdkUv) 
    {
        this.sdkUv = sdkUv;
    }

    public Long getSdkUv() 
    {
        return sdkUv;
    }
    public void setAdvertRequestCount(Long advertRequestCount) 
    {
        this.advertRequestCount = advertRequestCount;
    }

    public Long getAdvertRequestCount() 
    {
        return advertRequestCount;
    }
    public void setRejectReason(String rejectReason) 
    {
        this.rejectReason = rejectReason;
    }

    public String getRejectReason() 
    {
        return rejectReason;
    }
    public void setMediaExDivide(Long mediaExDivide) 
    {
        this.mediaExDivide = mediaExDivide;
    }

    public Long getMediaExDivide() 
    {
        return mediaExDivide;
    }
    public void setMediaDueDivide(Long mediaDueDivide) 
    {
        this.mediaDueDivide = mediaDueDivide;
    }

    public Long getMediaDueDivide() 
    {
        return mediaDueDivide;
    }
    public void setCashRequirementStatus(Integer cashRequirementStatus) 
    {
        this.cashRequirementStatus = cashRequirementStatus;
    }

    public Integer getCashRequirementStatus() 
    {
        return cashRequirementStatus;
    }
    public void setMediaOperation(String mediaOperation) 
    {
        this.mediaOperation = mediaOperation;
    }

    public String getMediaOperation() 
    {
        return mediaOperation;
    }
    public void setRiskControlOperation(String riskControlOperation) 
    {
        this.riskControlOperation = riskControlOperation;
    }

    public String getRiskControlOperation() 
    {
        return riskControlOperation;
    }
    public void setCashTime(Date cashTime) 
    {
        this.cashTime = cashTime;
    }

    public Date getCashTime() 
    {
        return cashTime;
    }
    public void setAuditTime(Date auditTime) 
    {
        this.auditTime = auditTime;
    }

    public Date getAuditTime() 
    {
        return auditTime;
    }
    public void setHzCashOrderId(Long hzCashOrderId) 
    {
        this.hzCashOrderId = hzCashOrderId;
    }

    public Long getHzCashOrderId() 
    {
        return hzCashOrderId;
    }
    public void setHegsCashOrderId(Long hegsCashOrderId) 
    {
        this.hegsCashOrderId = hegsCashOrderId;
    }

    public Long getHegsCashOrderId() 
    {
        return hegsCashOrderId;
    }
    public void setHzCashStatus(Long hzCashStatus) 
    {
        this.hzCashStatus = hzCashStatus;
    }

    public Long getHzCashStatus() 
    {
        return hzCashStatus;
    }
    public void setHegsCashStatus(Long hegsCashStatus) 
    {
        this.hegsCashStatus = hegsCashStatus;
    }

    public Long getHegsCashStatus() 
    {
        return hegsCashStatus;
    }
    public void setHzAdConsume(Long hzAdConsume) 
    {
        this.hzAdConsume = hzAdConsume;
    }

    public Long getHzAdConsume() 
    {
        return hzAdConsume;
    }
    public void setHegsAdConsume(Long hegsAdConsume) 
    {
        this.hegsAdConsume = hegsAdConsume;
    }

    public Long getHegsAdConsume() 
    {
        return hegsAdConsume;
    }
    public void setHzExConsumeTotal(Long hzExConsumeTotal) 
    {
        this.hzExConsumeTotal = hzExConsumeTotal;
    }

    public Long getHzExConsumeTotal() 
    {
        return hzExConsumeTotal;
    }
    public void setHegsExConsumeTotal(Long hegsExConsumeTotal) 
    {
        this.hegsExConsumeTotal = hegsExConsumeTotal;
    }

    public Long getHegsExConsumeTotal() 
    {
        return hegsExConsumeTotal;
    }
    public void setHzConsumeTotal(Long hzConsumeTotal) 
    {
        this.hzConsumeTotal = hzConsumeTotal;
    }

    public Long getHzConsumeTotal() 
    {
        return hzConsumeTotal;
    }
    public void setHegsConsumeTotal(Long hegsConsumeTotal) 
    {
        this.hegsConsumeTotal = hegsConsumeTotal;
    }

    public Long getHegsConsumeTotal() 
    {
        return hegsConsumeTotal;
    }
    public void setHzMediaExDivide(Long hzMediaExDivide) 
    {
        this.hzMediaExDivide = hzMediaExDivide;
    }

    public Long getHzMediaExDivide() 
    {
        return hzMediaExDivide;
    }
    public void setHegsMediaExDivide(Long hegsMediaExDivide) 
    {
        this.hegsMediaExDivide = hegsMediaExDivide;
    }

    public Long getHegsMediaExDivide() 
    {
        return hegsMediaExDivide;
    }
    public void setHzMediaDueDivide(Long hzMediaDueDivide) 
    {
        this.hzMediaDueDivide = hzMediaDueDivide;
    }

    public Long getHzMediaDueDivide() 
    {
        return hzMediaDueDivide;
    }
    public void setHegsMediaDueDivide(Long hegsMediaDueDivide) 
    {
        this.hegsMediaDueDivide = hegsMediaDueDivide;
    }

    public Long getHegsMediaDueDivide() 
    {
        return hegsMediaDueDivide;
    }
    public void setCashConsume(BigDecimal cashConsume) 
    {
        this.cashConsume = cashConsume;
    }

    public BigDecimal getCashConsume() 
    {
        return cashConsume;
    }
    public void setHzCashConsume(BigDecimal hzCashConsume) 
    {
        this.hzCashConsume = hzCashConsume;
    }

    public BigDecimal getHzCashConsume() 
    {
        return hzCashConsume;
    }
    public void setHegsCashConsume(BigDecimal hegsCashConsume) 
    {
        this.hegsCashConsume = hegsCashConsume;
    }

    public BigDecimal getHegsCashConsume() 
    {
        return hegsCashConsume;
    }
    public void setHcdjCashOrderId(Long hcdjCashOrderId) 
    {
        this.hcdjCashOrderId = hcdjCashOrderId;
    }

    public Long getHcdjCashOrderId() 
    {
        return hcdjCashOrderId;
    }
    public void setHcdjCashStatus(Long hcdjCashStatus) 
    {
        this.hcdjCashStatus = hcdjCashStatus;
    }

    public Long getHcdjCashStatus() 
    {
        return hcdjCashStatus;
    }
    public void setHcdjAdConsume(Long hcdjAdConsume) 
    {
        this.hcdjAdConsume = hcdjAdConsume;
    }

    public Long getHcdjAdConsume() 
    {
        return hcdjAdConsume;
    }
    public void setHcdjExConsumeTotal(Long hcdjExConsumeTotal) 
    {
        this.hcdjExConsumeTotal = hcdjExConsumeTotal;
    }

    public Long getHcdjExConsumeTotal() 
    {
        return hcdjExConsumeTotal;
    }
    public void setHcdjConsumeTotal(Long hcdjConsumeTotal) 
    {
        this.hcdjConsumeTotal = hcdjConsumeTotal;
    }

    public Long getHcdjConsumeTotal() 
    {
        return hcdjConsumeTotal;
    }
    public void setHcdjMediaExDivide(Long hcdjMediaExDivide) 
    {
        this.hcdjMediaExDivide = hcdjMediaExDivide;
    }

    public Long getHcdjMediaExDivide() 
    {
        return hcdjMediaExDivide;
    }
    public void setHcdjMediaDueDivide(Long hcdjMediaDueDivide) 
    {
        this.hcdjMediaDueDivide = hcdjMediaDueDivide;
    }

    public Long getHcdjMediaDueDivide() 
    {
        return hcdjMediaDueDivide;
    }
    public void setHcdjCashConsume(BigDecimal hcdjCashConsume) 
    {
        this.hcdjCashConsume = hcdjCashConsume;
    }

    public BigDecimal getHcdjCashConsume() 
    {
        return hcdjCashConsume;
    }
    public void setHzPreSettleOrderId(Long hzPreSettleOrderId) 
    {
        this.hzPreSettleOrderId = hzPreSettleOrderId;
    }

    public Long getHzPreSettleOrderId() 
    {
        return hzPreSettleOrderId;
    }
    public void setHegsPreSettleOrderId(Long hegsPreSettleOrderId) 
    {
        this.hegsPreSettleOrderId = hegsPreSettleOrderId;
    }

    public Long getHegsPreSettleOrderId() 
    {
        return hegsPreSettleOrderId;
    }
    public void setHcdjPreSettleOrderId(Long hcdjPreSettleOrderId) 
    {
        this.hcdjPreSettleOrderId = hcdjPreSettleOrderId;
    }

    public Long getHcdjPreSettleOrderId() 
    {
        return hcdjPreSettleOrderId;
    }
    public void setHzPreSettleStatus(Long hzPreSettleStatus) 
    {
        this.hzPreSettleStatus = hzPreSettleStatus;
    }

    public Long getHzPreSettleStatus() 
    {
        return hzPreSettleStatus;
    }
    public void setHegsPreSettleStatus(Long hegsPreSettleStatus) 
    {
        this.hegsPreSettleStatus = hegsPreSettleStatus;
    }

    public Long getHegsPreSettleStatus() 
    {
        return hegsPreSettleStatus;
    }
    public void setHcdjPreSettleStatus(Long hcdjPreSettleStatus) 
    {
        this.hcdjPreSettleStatus = hcdjPreSettleStatus;
    }

    public Long getHcdjPreSettleStatus() 
    {
        return hcdjPreSettleStatus;
    }

    public Long getAdConsumeOriginal() {
        return adConsumeOriginal;
    }

    public void setAdConsumeOriginal(Long adConsumeOriginal) {
        this.adConsumeOriginal = adConsumeOriginal;
    }

    public Long getCashConsumeOriginal() {
        return cashConsumeOriginal;
    }

    public void setCashConsumeOriginal(Long cashConsumeOriginal) {
        this.cashConsumeOriginal = cashConsumeOriginal;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("mediaId", getMediaId())
            .append("appId", getAppId())
            .append("slotId", getSlotId())
            .append("launchCount", getLaunchCount())
            .append("exposureCount", getExposureCount())
            .append("clickCount", getClickCount())
            .append("clickCountUv", getClickCountUv())
            .append("consumeTotal", getConsumeTotal())
            .append("efClickCount", getEfClickCount())
            .append("curDate", getCurDate())
            .append("settlementStatus", getSettlementStatus())
            .append("gmtCreate", getGmtCreate())
            .append("gmtModified", getGmtModified())
            .append("adConsume", getAdConsume())
            .append("exConsumeTotal", getExConsumeTotal())
            .append("cashOrderId", getCashOrderId())
            .append("cashStatus", getCashStatus())
            .append("actExposeCount", getActExposeCount())
            .append("actClickCount", getActClickCount())
            .append("sdkUv", getSdkUv())
            .append("advertRequestCount", getAdvertRequestCount())
            .append("rejectReason", getRejectReason())
            .append("mediaExDivide", getMediaExDivide())
            .append("mediaDueDivide", getMediaDueDivide())
            .append("cashRequirementStatus", getCashRequirementStatus())
            .append("mediaOperation", getMediaOperation())
            .append("riskControlOperation", getRiskControlOperation())
            .append("cashTime", getCashTime())
            .append("auditTime", getAuditTime())
            .append("hzCashOrderId", getHzCashOrderId())
            .append("hegsCashOrderId", getHegsCashOrderId())
            .append("hzCashStatus", getHzCashStatus())
            .append("hegsCashStatus", getHegsCashStatus())
            .append("hzAdConsume", getHzAdConsume())
            .append("hegsAdConsume", getHegsAdConsume())
            .append("hzExConsumeTotal", getHzExConsumeTotal())
            .append("hegsExConsumeTotal", getHegsExConsumeTotal())
            .append("hzConsumeTotal", getHzConsumeTotal())
            .append("hegsConsumeTotal", getHegsConsumeTotal())
            .append("hzMediaExDivide", getHzMediaExDivide())
            .append("hegsMediaExDivide", getHegsMediaExDivide())
            .append("hzMediaDueDivide", getHzMediaDueDivide())
            .append("hegsMediaDueDivide", getHegsMediaDueDivide())
            .append("cashConsume", getCashConsume())
            .append("hzCashConsume", getHzCashConsume())
            .append("hegsCashConsume", getHegsCashConsume())
            .append("hcdjCashOrderId", getHcdjCashOrderId())
            .append("hcdjCashStatus", getHcdjCashStatus())
            .append("hcdjAdConsume", getHcdjAdConsume())
            .append("hcdjExConsumeTotal", getHcdjExConsumeTotal())
            .append("hcdjConsumeTotal", getHcdjConsumeTotal())
            .append("hcdjMediaExDivide", getHcdjMediaExDivide())
            .append("hcdjMediaDueDivide", getHcdjMediaDueDivide())
            .append("hcdjCashConsume", getHcdjCashConsume())
            .append("hzPreSettleOrderId", getHzPreSettleOrderId())
            .append("hegsPreSettleOrderId", getHegsPreSettleOrderId())
            .append("hcdjPreSettleOrderId", getHcdjPreSettleOrderId())
            .append("hzPreSettleStatus", getHzPreSettleStatus())
            .append("hegsPreSettleStatus", getHegsPreSettleStatus())
            .append("hcdjPreSettleStatus", getHcdjPreSettleStatus())
            .toString();
    }
}
