package cn.com.duiba.tuia.ssp.center.api.dto.monthreport;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 获取月报相关数据接口的请求参数
 *
 * @author fangzhipeng
 * @date 2018/9/15
 */
@ApiModel
public class ReqMonthReportDataDto implements Serializable {

    private static final long serialVersionUID = -127484932739390882L;

    /**
     * 媒体账号id
     */
    @NotNull(message = "媒体id不能为空")
    @ApiModelProperty(value = "媒体Id", required = true)
    private Long mediaId;

    /**
     * 查询月报的日期 yyyy-MM 格式
     */
    @NotNull(message = "月报日期不能为空")
    @ApiModelProperty(value = "月报日期", required = true)
    private String reportDate;

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getReportDate() {
        return reportDate;
    }

    public void setReportDate(String reportDate) {
        this.reportDate = reportDate;
    }
}
