package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.Date;

/**
 * 通知（站内信）媒体关联DTO
 *
 * @author songjiaxing
 *
 */
public class NoticeStatisticsDto extends BaseDto {


	private static final long serialVersionUID = 8096085624502761424L;

	/**
	 * 媒体id
	 */
	private Long mediaId;

	/**
	 * 通知id
	 */
	private Long noticeId;

	/**
	 * 弹窗访问UV
	 */
	private Long popAccessUv;

	/**
	 * 首页访问UV
	 */
	private Long homeAccessUv;

	/**
	 * 消息访问UV
	 */
	private Long messageAccessUv;

	/**
	 * 路径类型（0：弹窗，1：首页，2：消息访问")
	 */
	private Integer pathType;


	/**
	 * 阅读点击次数
	 */
	private Long readPv;


	public Long getPopAccessUv() {
		return popAccessUv;
	}

	public void setPopAccessUv(Long popAccessUv) {
		this.popAccessUv = popAccessUv;
	}

	public Long getHomeAccessUv() {
		return homeAccessUv;
	}

	public void setHomeAccessUv(Long homeAccessUv) {
		this.homeAccessUv = homeAccessUv;
	}

	public Long getMessageAccessUv() {
		return messageAccessUv;
	}

	public void setMessageAccessUv(Long messageAccessUv) {
		this.messageAccessUv = messageAccessUv;
	}

	public Long getMediaId() {
		return mediaId;
	}

	public void setMediaId(Long mediaId) {
		this.mediaId = mediaId;
	}

	public Long getNoticeId() {
		return noticeId;
	}

	public void setNoticeId(Long noticeId) {
		this.noticeId = noticeId;
	}

	public Integer getPathType() {
		return pathType;
	}

	public void setPathType(Integer pathType) {
		this.pathType = pathType;
	}

	public Long getReadPv() {
		return readPv;
	}

	public void setReadPv(Long readPv) {
		this.readPv = readPv;
	}

	public static void getDtoByType(Integer type,NoticeStatisticsDto dto){
		if (type==0) {
		    dto.setPopAccessUv(1L);
            dto.setHomeAccessUv(0L);
            dto.setMessageAccessUv(0L);
        }else if (type==1) {
            dto.setPopAccessUv(0L);
            dto.setHomeAccessUv(1L);
            dto.setMessageAccessUv(0L);
        }else if (type==2) {
            dto.setPopAccessUv(0L);
            dto.setHomeAccessUv(0L);
            dto.setMessageAccessUv(1L);
        }
	}
}
