package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveInfo;
import cn.com.duiba.tuia.ssp.center.api.tool.DataMathUtil;
import lombok.Data;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * ClassName:AgentSettledMonthReportRsp <br/>
 * Function: 代理结算月报表. <br/>
 * Date: 2019年07月10日 下午3:52:36 <br/>
 * 
 * @author yuantong
 */
@SensitiveInfo(sensitiveFields = {"account","appName"})
public class AgentSettledMonthReportRsp extends BaseAccountMonthReportRsp implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 3670897234679755232L;

    /** 最终分成 */
    private Long finalShare;

    /** 结算状态：0-待结算，1-默认结算，2-拒绝结算 */
    private Integer checkStatus;

    /** 审核状态：0-拒绝，1-通过 */
    private Integer auditStatus;

    /** 分成比例 */
    private Double divisionProportion;

    /** 实际分成比例 */
    private Double actualProportion;
    
    /**用户类别*/
    private Integer accountType;
    
    /**调整金额*/
    private Long adjustmentAmount;
    
    /**税率*/
    private Integer taxRate;

    /** 纳税人类型 */
    private Integer taxpayerType;
   
    /**月账单生成日期*/
    private String gmtCreate;
    
    /**月账单结算日期*/
    private String currentDate;
    
    /**杭州实际分成*/
    private Long hzFinalShare;

    /**霍尔果斯实际分成*/
    private Long hegsFinalShare;

    /**霍城兑捷实际分成*/
    private Long hcdjFinalShare;

    /** 代理结算的主体 */
    private Byte settleCompanyType;

    /**杭州广告消耗*/
    private Long hzAdConsume;

    /**霍尔果斯广告消耗*/
    private Long hegsAdConsume;

    /**霍城兑捷广告消耗*/
    private Long hcdjAdConsume;

    /**杭州应得收入*/
    private Long hzConsumeTotal;

    /**霍尔果斯应得收入*/
    private Long hegsConsumeTotal;

    /**霍城兑捷应得收入*/
    private Long hcdjConsumeTotal;

    /**杭州预计收入*/
    private Long hzExConsumeTotal;

    /**霍尔果斯预计收入*/
    private Long hegsExConsumeTotal;

    /**霍城兑捷预计收入*/
    private Long hcdjExConsumeTotal;

    /**
     * 平台利润
     */
    private Long platformProfit;

    public Long getPlatformProfit() {
        return DataMathUtil.calculateProfitData(super.getAdvertConsume(),this.finalShare);
    }

    public void setPlatformProfit(Long platformProfit) {
        this.platformProfit = platformProfit;
    }

    public Long getFinalShare() {
        return finalShare;
    }

    public void setFinalShare(final Long finalShare) {
        this.finalShare = finalShare;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(final Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(final Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Double getDivisionProportion() {
        return divisionProportion;
    }

    public void setDivisionProportion(final Double divisionProportion) {
        this.divisionProportion = divisionProportion;
    }

    public Double getActualProportion() {
        return actualProportion;
    }

    public void setActualProportion(final Double actualProportion) {
        this.actualProportion = actualProportion;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(final Integer accountType) {
        this.accountType = accountType;
    }

    public Long getAdjustmentAmount() {
        return adjustmentAmount;
    }

    public void setAdjustmentAmount(final Long adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
    }

    public Integer getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(final Integer taxRate) {
        this.taxRate = taxRate;
    }

    public Integer getTaxpayerType() {
        return taxpayerType;
    }

    public void setTaxpayerType(Integer taxpayerType) {
        this.taxpayerType = taxpayerType;
    }

    public String getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(final String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getCurrentDate() {
        return currentDate;
    }

    public void setCurrentDate(final String currentDate) {
        this.currentDate = currentDate;
    }

    public Long getHzFinalShare() {
        return hzFinalShare;
    }

    public void setHzFinalShare(final Long hzFinalShare) {
        this.hzFinalShare = hzFinalShare;
    }

    public Long getHegsFinalShare() {
        return hegsFinalShare;
    }

    public void setHegsFinalShare(final Long hegsFinalShare) {
        this.hegsFinalShare = hegsFinalShare;
    }

    public Long getHcdjFinalShare() {
        return hcdjFinalShare;
    }

    public void setHcdjFinalShare(final Long hcdjFinalShare) {
        this.hcdjFinalShare = hcdjFinalShare;
    }

    public Byte getSettleCompanyType() {
        return settleCompanyType;
    }

    public void setSettleCompanyType(final Byte settleCompanyType) {
        this.settleCompanyType = settleCompanyType;
    }

    public Long getHzAdConsume() {
        return hzAdConsume;
    }

    public void setHzAdConsume(final Long hzAdConsume) {
        this.hzAdConsume = hzAdConsume;
    }

    public Long getHegsAdConsume() {
        return hegsAdConsume;
    }

    public void setHegsAdConsume(final Long hegsAdConsume) {
        this.hegsAdConsume = hegsAdConsume;
    }

    public Long getHcdjAdConsume() {
        return hcdjAdConsume;
    }

    public void setHcdjAdConsume(final Long hcdjAdConsume) {
        this.hcdjAdConsume = hcdjAdConsume;
    }

    public Long getHzConsumeTotal() {
        return hzConsumeTotal;
    }

    public void setHzConsumeTotal(final Long hzConsumeTotal) {
        this.hzConsumeTotal = hzConsumeTotal;
    }

    public Long getHegsConsumeTotal() {
        return hegsConsumeTotal;
    }

    public void setHegsConsumeTotal(final Long hegsConsumeTotal) {
        this.hegsConsumeTotal = hegsConsumeTotal;
    }

    public Long getHcdjConsumeTotal() {
        return hcdjConsumeTotal;
    }

    public void setHcdjConsumeTotal(final Long hcdjConsumeTotal) {
        this.hcdjConsumeTotal = hcdjConsumeTotal;
    }

    public Long getHzExConsumeTotal() {
        return hzExConsumeTotal;
    }

    public void setHzExConsumeTotal(final Long hzExConsumeTotal) {
        this.hzExConsumeTotal = hzExConsumeTotal;
    }

    public Long getHegsExConsumeTotal() {
        return hegsExConsumeTotal;
    }

    public void setHegsExConsumeTotal(final Long hegsExConsumeTotal) {
        this.hegsExConsumeTotal = hegsExConsumeTotal;
    }

    public Long getHcdjExConsumeTotal() {
        return hcdjExConsumeTotal;
    }

    public void setHcdjExConsumeTotal(final Long hcdjExConsumeTotal) {
        this.hcdjExConsumeTotal = hcdjExConsumeTotal;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
