package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.ssp.center.api.constant.PrePayStatus;
import cn.com.duiba.tuia.ssp.center.api.dto.*;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemotePrePayService {

    /**
     * 查询账号下所有未抵扣已打款的账单
     * @param mediaId
     * @return
     */
    List<PrePayDto> selectPrePayAmountByMediaId(Long mediaId);

    /**
     * 查询所有正在审核中订单,防止审核中订单被重复添加
     * @param appId
     * @return
     */
    Integer selectCheckOrderCount(Long appId);
    
    Integer selectCheckOrderCountByMediaId(Long mediaId);

    /**
     * 根据媒体账号获取已打款预付款数
     *
     * @param mediaId
     * @return
     */
    Integer selectWithdrawCountByMediaId(Long mediaId);

    PageDto<PrePayDto> getPrePayList(ReqPrePayPage req);

    PageDto<PrePayDto> listNewestPrePayByPage(ReqPrePayPage req);

    List<PrePayDto> listNewestPrePay(ReqPrePayPage req);

    Integer updateStatus(PrePayStatus nowStatus, PrePayStatus nextStatus, Long orderId, String rejectReason);

    Integer insert(PrePayDto req);
    /** 查询媒体下所有的预付款单 */
    Integer selectCountByMediaId(Long mediaId);

    /** 分页查询媒体下预付款单 */
    List<PrePayDto> selectPageListByMediaId(Long mediaId, Integer start, Integer limit);

    List<PrePayDto> selectByCashOrderId(Long cashOrderId);

    List<PrePayDto> selectByCashOrderIds(List<Long> cashOrderIds);

    PrePayDto selectByOrderId(Long orderId);

    Integer insertRecord(PrePayRecordDto req);
    
    List<PrePayDto> selectPrePayListByRemitTime(Long mediaId,String queryTime);

    /**
     * 根据预付款单号 获取审批记录
     * @param prePayOrderId
     * @return
     */
    List<PrePayRecordDto> selectRecordsByOrderId(Long prePayOrderId);

    /**
     * 更新预付款备注信息
     *
     * @param prePayOrderId
     * @param payImg
     * @param receiveStatus
     * @param remark
     * @return
     */
    Integer updatePrePayRemark(Long prePayOrderId, String payImg, int receiveStatus, String remark);

    /**
     * 查询余额
     * @param mediaId
     * @return
     */
    TuiaCompanyValueDto selectAllBalance(Long mediaId);

    /**
     * 查询余额
     * @param mediaIds
     * @return
     */
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    Map<Long, TuiaCompanyValueDto> selectAllBalanceByMediaIds(List<Long> mediaIds);

    /**
     * 查询账号下所有未抵扣已打款的账单
     * @param mediaId
     * @return
     */
    List<PrePayDto> selectPrePayAmountByMediaIdAndType(Long mediaId, Integer companyType);

    /**
     * 根据提现单号查找
     * @param cashOrderIds
     * @return
     */
    List<PrePayRecordDto> selectRecordsByCashOrderIds(List<Long> cashOrderIds);

    List<PrePayDto> selectByOrderIds(List<Long> orderdIs);

    List<PrePayDto> selectPrePaySumAmountList(List<Long> mediaIds,List<Integer> status);

    /**
     * @Description  根据结算单查询抵扣记录详情
     * @Date 17:15 2020-04-15
     * @Param [preSettleOrderId]
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.PreSettleDeductRecordDto>
     **/
    List<PreSettleDeductRecordDto> selectRecords(Long preSettleOrderId);

    /**
     * 查询指定日期之前的预付款金额
     */
    List<PrePayDto> listPrePayBeforeDate(ReqPrePayPage req);

    /**
     * 最新账单
     */
    List<PrePayDto> listLastPrePayList(ReqPrePayPage req);

    /**
     * 查询账号各主体所有预付款金额
     */
    PrePayDto getTotalPrePayAmount(Long mediaId);

    /**
     * 查询起始日期之后的账号各主体所有预付款金额
     */
    PrePayDto getTotalPrePayAmountStartDate(Long mediaId, String startDate);
}
