/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.annotation;

import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveInfo;
import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveType;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SensitiveUtil {
    private SensitiveUtil() {
    }

    public static <T> void sensitive(T o) {
        try {
            if (o == null) {
                return;
            }
            List<Field> fileds = SensitiveUtil.findAllField(o.getClass());
            if (CollectionUtils.isEmpty(fileds)) {
                return;
            }
            for (Field field : fileds) {
                if (!field.isAnnotationPresent(SensitiveInfo.class) || field.getType() != String.class) continue;
                field.setAccessible(true);
                SensitiveInfo sensitiveInfo = field.getAnnotation(SensitiveInfo.class);
                String value = (String)field.get(o);
                SensitiveType type = sensitiveInfo.sensitiveType();
                if (SensitiveType.APP_NAME.equals((Object)type)) continue;
                field.set(o, SensitiveUtil.sensitiveStr(value, type));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> void sensitiveAppName(T o) {
        try {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = o.getClass().getDeclaredFields()) {
                SensitiveInfo annotation;
                SensitiveType sensitiveType;
                if (!declaredField.isAnnotationPresent(SensitiveInfo.class) || !SensitiveType.APP_NAME.equals((Object)(sensitiveType = (annotation = declaredField.getAnnotation(SensitiveInfo.class)).sensitiveType()))) continue;
                declaredField.setAccessible(true);
                String value = (String)declaredField.get(o);
                declaredField.set(o, SensitiveUtil.sensitiveStr(value, sensitiveType));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> void sensitive(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(SensitiveUtil::sensitive);
    }

    private static List<Field> findAllField(Class<?> clazz) {
        ArrayList fileds = Lists.newArrayList();
        SensitiveInfo sensitiveInfo = clazz.getAnnotation(SensitiveInfo.class);
        if (null != sensitiveInfo && sensitiveInfo.sensitiveFields() != null) {
            String[] fieldNames;
            for (String name : fieldNames = sensitiveInfo.sensitiveFields()) {
                fileds.add(SensitiveUtil.findField(clazz, name));
            }
        }
        return fileds;
    }

    private static Field findField(Class<?> clazz, String name) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        while (clazz != Object.class) {
            Class<?> supClazz = clazz.getSuperclass();
            if (null == supClazz) continue;
            try {
                field = supClazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            clazz = supClazz;
        }
        return field;
    }

    public static String sensitiveStr(String concent, SensitiveType type) {
        switch (type) {
            case USERNAME: {
                return SensitiveUtil.sensitive4uname(concent);
            }
            case EMAIL: {
                return SensitiveUtil.sensitive4email(concent);
            }
            case MOBILE: {
                return SensitiveUtil.sensitive4mobile(concent);
            }
            case APP_NAME: {
                return "***";
            }
        }
        return "";
    }

    private static String sensitive4uname(String concent) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{concent})) {
            String first = StringUtils.left((String)concent, (int)1);
            return StringUtils.replace((String)concent, (String)first, (String)"*", (int)1);
        }
        return "";
    }

    private static String sensitive4mobile(String concent) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{concent})) {
            String head = StringUtils.left((String)concent, (int)3);
            String foot = StringUtils.right((String)concent, (int)4);
            return head + "****" + foot;
        }
        return "";
    }

    private static String sensitive4email(String concent) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{concent})) {
            String head = StringUtils.substring((String)concent, (int)0, (int)StringUtils.indexOf((CharSequence)concent, (CharSequence)"@"));
            return StringUtils.replace((String)concent, (String)head, (String)"****", (int)1);
        }
        return "";
    }
}

