package cn.com.duiba.tuia.ssp.center.api.constant;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2021/8/5
 * @Description
 * @Param
 * @return
 **/
@Getter
public enum ShareProportionAuditStatusEnum {
    /**
     * 待审核
     */
    PENDING_REVIEW(1, "待审核", YesterdayAuditStatusEnum.EMPTY),
    /**
     *审核通过
     */
    PASS(2, "审核通过", YesterdayAuditStatusEnum.PASS),
    /**
     *审核拒绝
     */
    REJECT(3, "审核拒绝", YesterdayAuditStatusEnum.REJECT),
    /**
     *审核超时
     */
    TIME_OUT(4, "审核超时", YesterdayAuditStatusEnum.EMPTY),
    /**
     *审核撤销
     */
    REVOKE(5, "审核撤销", YesterdayAuditStatusEnum.REVOKE),;

    private Integer code;

    private String desc;

    private YesterdayAuditStatusEnum yesterdayAuditStatusEnum;

    ShareProportionAuditStatusEnum(Integer code, String desc, YesterdayAuditStatusEnum yesterdayAuditStatusEnum){
        this.code = code;
        this.desc = desc;
        this.yesterdayAuditStatusEnum = yesterdayAuditStatusEnum;
    }

    public static ShareProportionAuditStatusEnum getInstanceByCode(Integer code){
        for (ShareProportionAuditStatusEnum shareProportionAuditStatusEnum : ShareProportionAuditStatusEnum.values()){
            if(shareProportionAuditStatusEnum.getCode().equals(code)){
                return shareProportionAuditStatusEnum;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code){
        for (ShareProportionAuditStatusEnum shareProportionAuditStatusEnum : ShareProportionAuditStatusEnum.values()){
            if(shareProportionAuditStatusEnum.getCode().equals(code)){
                return shareProportionAuditStatusEnum.desc;
            }
        }
        return "/";
    }

    public enum YesterdayAuditStatusEnum {
        /**
         * 空
         */
        EMPTY(1, "/"),
        /**
         *审核通过
         */
        PASS(2, "审核通过"),
        /**
         *审核拒绝
         */
        REJECT(3, "审核拒绝"),
        /**
         *审核超时
         */
        REVOKE(4, "审核超时"),;

        private Integer code;

        private String desc;

        YesterdayAuditStatusEnum(Integer code, String desc){
            this.code = code;
            this.desc = desc;
        }

        public Integer getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }

        public static String getDescByCode(Integer code){
            for (YesterdayAuditStatusEnum yesterdayAuditStatusEnum : YesterdayAuditStatusEnum.values()){
                if(yesterdayAuditStatusEnum.getCode().equals(code)){
                    return yesterdayAuditStatusEnum.desc;
                }
            }
            return "/";
        }
    }
}
