package cn.com.duiba.tuia.ssp.center.api.dto.finaceData;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 媒体广告位数据日统计对象 tb_media_slot_daily_statistics_merge
 * 
 * @author liuyajun
 * @date 2022-02-11
 */
public class MediaSlotDailyStatisticsDTO implements Serializable {

    private static final long serialVersionUID = -4426368433736267700L;

    /** 主键 */
    private Long id;

    /** 媒体用户id */
    private Long mediaId;

    /** 应用id */
    private Long appId;

    /** 应用名称 */
    private String appName;

    /** 应用所属平台 */
    private String platform;

    /** 广告位id */
    private Long slotId;

    /** 广告位名 */
    private String slotName;

    /** 广告位类型 */
    private Integer slotType;

    /** 广告位规格ID */
    private Long slotMsId;

    /** 入口曝光量 */
    private Long actExposeCount;

    /** 入口点击量 */
    private Long actClickCount;

    /** 入口点击UV */
    private Long actClickUv;

    /** 入口点击率 */
    private Long actClickRate;

    /** 活动请求UV */
    private Long actRequestUv;

    /** 活动请求PV */
    private Long actRequestCount;

    /** 活动参与次数 */
    private Long participateCount;

    /** 活动参与人数 */
    private Long participateUv;

    /** 参与率 */
    private Long actParticipateRate;

    /** 复参数 */
    private Long rptParticipateCount;

    /** 活动广告券请求 */
    private Long advertRequestCount;

    /** 每日发券量 */
    private Long launchCount;

    /** 请求成功率 */
    private Long requestSuccessRate;

    /** 发券成功率 */
    private Long launchSuccessRate;

    /** 广告曝光量 */
    private Long advertExposureCount;

    /** 广告点击量 */
    private Long advertClickCount;

    /** 广告点击率 */
    private Long advertClickRate;

    /** 广告点击单价(分) */
    private Long advertPerClickFee;

    /** 广告收入/广告点击量 */
    private Long arpu;

    /** 千次曝光产生的发券 */
    private Long spm;

    /** 千次曝光产生的广告消耗（分） */
    private Long ecpm;

    /** 活动UV单价（分） */
    private Long actPerRequestFee;

    /** 活动点击单价（分） */
    private Long actPerClickFee;

    /** 广告消耗（分） */
    private Long adConsume;

    /** 媒体预计分成（分） */
    private Long exConsumeTotal;

    /** 媒体应得分成（分） */
    private Long consumeTotal;

    /** 当天日期 */
    private Date curDate;

    /** 创建时间 */
    private Date gmtCreate;

    /** 修改时间 */
    private Date gmtModified;

    /** 有效点击次数 */
    private Long efClickCount;

    /** 有效点击UV */
    private Long advertClickCountUv;

    /** 流量引导页访问PV */
    private Long liuliangPv;

    /** 流量引导页访问UV */
    private Long liuliangUv;

    /** 广告位访问PV */
    private Long sdkPv;

    /** 广告位访问UV */
    private Long sdkUv;

    /** 活动来源 0：兑吧活动  1：推啊活动  2：流量引导页 */
    private Integer resource;

    /** 广告位返回成功PV */
    private Long actSucResponseCount;

    /** 高风险发券量 */
    private Long highriskLaunch;

    /** 媒体预计分成按分存储 */
    private Long mediaExDivide;

    /** 媒体应得分成按分存储 */
    private Long mediaDueDivide;

    /** 理论广告消耗（分） */
    private Long logicalConsume;

    /** 广告位曝光uv */
    private Long actExposeUv;

    /** 杭州每日广告消耗(分) */
    private Long hzAdConsume;

    /** 霍尔果斯每日广告消耗(分) */
    private Long hegsAdConsume;

    /** 杭州每日媒体预计分成(分） */
    private Long hzExConsumeTotal;

    /** 霍尔果斯每日媒体预计分成(分） */
    private Long hegsExConsumeTotal;

    /** 杭州每日消费(分) */
    private Long hzConsumeTotal;

    /** 霍尔果斯每日消费(分) */
    private Long hegsConsumeTotal;

    /** 杭州媒体预计分成按分存储 */
    private Long hzMediaExDivide;

    /** 霍尔果斯媒体预计分成按分存储 */
    private Long hegsMediaExDivide;

    /** 杭州媒体应得分成按分存储 */
    private Long hzMediaDueDivide;

    /** 霍尔果斯媒体应得分成按分存储 */
    private Long hegsMediaDueDivide;

    /** 付费券发券量      计费点击日志中，点击单价＞0的广告对应的发券量 */
    private Long payLaunchPv;

    /** 付费券曝光量      计费点击日志中，点击单价＞0的广告对应的曝光量 */
    private Long payExposurePv;

    /** 付费券计费点击量        计费点击日志中，点击单价＞0的广告对应的计费点击量 */
    private Long payEfClicks;

    /** ip访问量 */
    private Long ipRequestPv;

    /** 广告位有效访问pv */
    private Long slotEfRequestPv;

    /** 新客访问量 */
    private Long newRequestUv;

    /** 广告券请求数（互动） */
    private Long advertRequestCountHd;

    /** 广告券请求数（展示） */
    private Long advertRequestCountZs;

    /** 广告发券量（互动） */
    private Long launchCountHd;

    /** 广告发券量（展示） */
    private Long launchCountZs;

    /** 付费券发券量（互动） */
    private Long payLaunchHd;

    /** 付费券发券量（展示） */
    private Long payLaunchZs;

    /** 广告券曝光量（互动） */
    private Long advertExposureCountHd;

    /** 广告券曝光量（展示） */
    private Long advertExposureCountZs;

    /** 广告券点击量（互动） */
    private Long advertClickCountHd;

    /** 广告券点击量（展示） */
    private Long advertClickCountZs;

    /** 广告消耗（互动） */
    private Long adConsumeHd;

    /** 广告消耗（展示） */
    private Long adConsumeZs;

    /** 接入广告类型 0-互动广告 1-展示广告 */
    private Integer slotAccessType;

    /** 现金消耗(分) */
    private BigDecimal cashConsume;

    /** 杭州现金消耗(分) */
    private BigDecimal hzCashConsume;

    /** 霍尔果斯现金消耗(分) */
    private BigDecimal hegsCashConsume;

    /** 霍城兑捷每日广告消耗(分) */
    private Long hcdjAdConsume;

    /** 霍城兑捷每日媒体预计分成(分） */
    private Long hcdjExConsumeTotal;

    /** 霍城兑捷每日消费(分) */
    private Long hcdjConsumeTotal;

    /** 霍城兑捷媒体预计分成按分存储 */
    private Long hcdjMediaExDivide;

    /** 霍城兑捷媒体应得分成按分存储 */
    private Long hcdjMediaDueDivide;

    /** 霍城兑捷现金消耗(分) */
    private BigDecimal hcdjCashConsume;

    /** 请求 serving 次数 */
    private Long requestCount;

    /** 下发 serving 成功返回次数 */
    private Long sendCount;

    /** 原有广告位访问UV */
    private Long sdkUvOriginal;

    /** 原有广告位有效访问pv */
    private Long slotEfRequestPvOriginal;

    /** 原有新客访问量 */
    private Long newRequestUvOriginal;

    /** 原有ip访问量 */
    private Long ipRequestPvOriginal;

    /** 原有广告消耗（分） */
    private Long adConsumeOriginal;

    /** 原有杭州每日广告消耗(分) */
    private Long hzAdConsumeOriginal;

    /** 原有霍尔果斯每日广告消耗(分) */
    private Long hegsAdConsumeOriginal;

    /** 原有霍城兑捷每日广告消耗(分) */
    private Long hcdjAdConsumeOriginal;

    /** 原有现金消耗(分) */
    private BigDecimal cashConsumeOriginal;

    /** 原有广告位访问PV */
    private Long sdkPvOriginal;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setMediaId(Long mediaId) 
    {
        this.mediaId = mediaId;
    }

    public Long getMediaId() 
    {
        return mediaId;
    }
    public void setAppId(Long appId) 
    {
        this.appId = appId;
    }

    public Long getAppId() 
    {
        return appId;
    }
    public void setAppName(String appName) 
    {
        this.appName = appName;
    }

    public String getAppName() 
    {
        return appName;
    }
    public void setPlatform(String platform) 
    {
        this.platform = platform;
    }

    public String getPlatform() 
    {
        return platform;
    }
    public void setSlotId(Long slotId) 
    {
        this.slotId = slotId;
    }

    public Long getSlotId() 
    {
        return slotId;
    }
    public void setSlotName(String slotName) 
    {
        this.slotName = slotName;
    }

    public String getSlotName() 
    {
        return slotName;
    }
    public void setSlotType(Integer slotType) 
    {
        this.slotType = slotType;
    }

    public Integer getSlotType() 
    {
        return slotType;
    }
    public void setSlotMsId(Long slotMsId) 
    {
        this.slotMsId = slotMsId;
    }

    public Long getSlotMsId() 
    {
        return slotMsId;
    }
    public void setActExposeCount(Long actExposeCount) 
    {
        this.actExposeCount = actExposeCount;
    }

    public Long getActExposeCount() 
    {
        return actExposeCount;
    }
    public void setActClickCount(Long actClickCount) 
    {
        this.actClickCount = actClickCount;
    }

    public Long getActClickCount() 
    {
        return actClickCount;
    }
    public void setActClickUv(Long actClickUv) 
    {
        this.actClickUv = actClickUv;
    }

    public Long getActClickUv() 
    {
        return actClickUv;
    }
    public void setActClickRate(Long actClickRate) 
    {
        this.actClickRate = actClickRate;
    }

    public Long getActClickRate() 
    {
        return actClickRate;
    }
    public void setActRequestUv(Long actRequestUv) 
    {
        this.actRequestUv = actRequestUv;
    }

    public Long getActRequestUv() 
    {
        return actRequestUv;
    }
    public void setActRequestCount(Long actRequestCount) 
    {
        this.actRequestCount = actRequestCount;
    }

    public Long getActRequestCount() 
    {
        return actRequestCount;
    }
    public void setParticipateCount(Long participateCount) 
    {
        this.participateCount = participateCount;
    }

    public Long getParticipateCount() 
    {
        return participateCount;
    }
    public void setParticipateUv(Long participateUv) 
    {
        this.participateUv = participateUv;
    }

    public Long getParticipateUv() 
    {
        return participateUv;
    }
    public void setActParticipateRate(Long actParticipateRate) 
    {
        this.actParticipateRate = actParticipateRate;
    }

    public Long getActParticipateRate() 
    {
        return actParticipateRate;
    }
    public void setRptParticipateCount(Long rptParticipateCount) 
    {
        this.rptParticipateCount = rptParticipateCount;
    }

    public Long getRptParticipateCount() 
    {
        return rptParticipateCount;
    }
    public void setAdvertRequestCount(Long advertRequestCount) 
    {
        this.advertRequestCount = advertRequestCount;
    }

    public Long getAdvertRequestCount() 
    {
        return advertRequestCount;
    }
    public void setLaunchCount(Long launchCount) 
    {
        this.launchCount = launchCount;
    }

    public Long getLaunchCount() 
    {
        return launchCount;
    }
    public void setRequestSuccessRate(Long requestSuccessRate) 
    {
        this.requestSuccessRate = requestSuccessRate;
    }

    public Long getRequestSuccessRate() 
    {
        return requestSuccessRate;
    }
    public void setLaunchSuccessRate(Long launchSuccessRate) 
    {
        this.launchSuccessRate = launchSuccessRate;
    }

    public Long getLaunchSuccessRate() 
    {
        return launchSuccessRate;
    }
    public void setAdvertExposureCount(Long advertExposureCount) 
    {
        this.advertExposureCount = advertExposureCount;
    }

    public Long getAdvertExposureCount() 
    {
        return advertExposureCount;
    }
    public void setAdvertClickCount(Long advertClickCount) 
    {
        this.advertClickCount = advertClickCount;
    }

    public Long getAdvertClickCount() 
    {
        return advertClickCount;
    }
    public void setAdvertClickRate(Long advertClickRate) 
    {
        this.advertClickRate = advertClickRate;
    }

    public Long getAdvertClickRate() 
    {
        return advertClickRate;
    }
    public void setAdvertPerClickFee(Long advertPerClickFee) 
    {
        this.advertPerClickFee = advertPerClickFee;
    }

    public Long getAdvertPerClickFee() 
    {
        return advertPerClickFee;
    }
    public void setArpu(Long arpu) 
    {
        this.arpu = arpu;
    }

    public Long getArpu() 
    {
        return arpu;
    }
    public void setSpm(Long spm) 
    {
        this.spm = spm;
    }

    public Long getSpm() 
    {
        return spm;
    }
    public void setEcpm(Long ecpm) 
    {
        this.ecpm = ecpm;
    }

    public Long getEcpm() 
    {
        return ecpm;
    }
    public void setActPerRequestFee(Long actPerRequestFee) 
    {
        this.actPerRequestFee = actPerRequestFee;
    }

    public Long getActPerRequestFee() 
    {
        return actPerRequestFee;
    }
    public void setActPerClickFee(Long actPerClickFee) 
    {
        this.actPerClickFee = actPerClickFee;
    }

    public Long getActPerClickFee() 
    {
        return actPerClickFee;
    }
    public void setAdConsume(Long adConsume) 
    {
        this.adConsume = adConsume;
    }

    public Long getAdConsume() 
    {
        return adConsume;
    }
    public void setExConsumeTotal(Long exConsumeTotal) 
    {
        this.exConsumeTotal = exConsumeTotal;
    }

    public Long getExConsumeTotal() 
    {
        return exConsumeTotal;
    }
    public void setConsumeTotal(Long consumeTotal) 
    {
        this.consumeTotal = consumeTotal;
    }

    public Long getConsumeTotal() 
    {
        return consumeTotal;
    }
    public void setCurDate(Date curDate) 
    {
        this.curDate = curDate;
    }

    public Date getCurDate() 
    {
        return curDate;
    }
    public void setGmtCreate(Date gmtCreate) 
    {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() 
    {
        return gmtCreate;
    }
    public void setGmtModified(Date gmtModified) 
    {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() 
    {
        return gmtModified;
    }
    public void setEfClickCount(Long efClickCount) 
    {
        this.efClickCount = efClickCount;
    }

    public Long getEfClickCount() 
    {
        return efClickCount;
    }
    public void setAdvertClickCountUv(Long advertClickCountUv) 
    {
        this.advertClickCountUv = advertClickCountUv;
    }

    public Long getAdvertClickCountUv() 
    {
        return advertClickCountUv;
    }
    public void setLiuliangPv(Long liuliangPv) 
    {
        this.liuliangPv = liuliangPv;
    }

    public Long getLiuliangPv() 
    {
        return liuliangPv;
    }
    public void setLiuliangUv(Long liuliangUv) 
    {
        this.liuliangUv = liuliangUv;
    }

    public Long getLiuliangUv() 
    {
        return liuliangUv;
    }
    public void setSdkPv(Long sdkPv) 
    {
        this.sdkPv = sdkPv;
    }

    public Long getSdkPv() 
    {
        return sdkPv;
    }
    public void setSdkUv(Long sdkUv) 
    {
        this.sdkUv = sdkUv;
    }

    public Long getSdkUv() 
    {
        return sdkUv;
    }
    public void setResource(Integer resource) 
    {
        this.resource = resource;
    }

    public Integer getResource() 
    {
        return resource;
    }
    public void setActSucResponseCount(Long actSucResponseCount) 
    {
        this.actSucResponseCount = actSucResponseCount;
    }

    public Long getActSucResponseCount() 
    {
        return actSucResponseCount;
    }
    public void setHighriskLaunch(Long highriskLaunch) 
    {
        this.highriskLaunch = highriskLaunch;
    }

    public Long getHighriskLaunch() 
    {
        return highriskLaunch;
    }
    public void setMediaExDivide(Long mediaExDivide) 
    {
        this.mediaExDivide = mediaExDivide;
    }

    public Long getMediaExDivide() 
    {
        return mediaExDivide;
    }
    public void setMediaDueDivide(Long mediaDueDivide) 
    {
        this.mediaDueDivide = mediaDueDivide;
    }

    public Long getMediaDueDivide() 
    {
        return mediaDueDivide;
    }
    public void setLogicalConsume(Long logicalConsume) 
    {
        this.logicalConsume = logicalConsume;
    }

    public Long getLogicalConsume() 
    {
        return logicalConsume;
    }
    public void setActExposeUv(Long actExposeUv) 
    {
        this.actExposeUv = actExposeUv;
    }

    public Long getActExposeUv() 
    {
        return actExposeUv;
    }
    public void setHzAdConsume(Long hzAdConsume) 
    {
        this.hzAdConsume = hzAdConsume;
    }

    public Long getHzAdConsume() 
    {
        return hzAdConsume;
    }
    public void setHegsAdConsume(Long hegsAdConsume) 
    {
        this.hegsAdConsume = hegsAdConsume;
    }

    public Long getHegsAdConsume() 
    {
        return hegsAdConsume;
    }
    public void setHzExConsumeTotal(Long hzExConsumeTotal) 
    {
        this.hzExConsumeTotal = hzExConsumeTotal;
    }

    public Long getHzExConsumeTotal() 
    {
        return hzExConsumeTotal;
    }
    public void setHegsExConsumeTotal(Long hegsExConsumeTotal) 
    {
        this.hegsExConsumeTotal = hegsExConsumeTotal;
    }

    public Long getHegsExConsumeTotal() 
    {
        return hegsExConsumeTotal;
    }
    public void setHzConsumeTotal(Long hzConsumeTotal) 
    {
        this.hzConsumeTotal = hzConsumeTotal;
    }

    public Long getHzConsumeTotal() 
    {
        return hzConsumeTotal;
    }
    public void setHegsConsumeTotal(Long hegsConsumeTotal)
    {
        this.hegsConsumeTotal = hegsConsumeTotal;
    }

    public Long getHegsConsumeTotal()
    {
        return hegsConsumeTotal;
    }
    public void setHzMediaExDivide(Long hzMediaExDivide) 
    {
        this.hzMediaExDivide = hzMediaExDivide;
    }

    public Long getHzMediaExDivide() 
    {
        return hzMediaExDivide;
    }
    public void setHegsMediaExDivide(Long hegsMediaExDivide) 
    {
        this.hegsMediaExDivide = hegsMediaExDivide;
    }

    public Long getHegsMediaExDivide() 
    {
        return hegsMediaExDivide;
    }
    public void setHzMediaDueDivide(Long hzMediaDueDivide) 
    {
        this.hzMediaDueDivide = hzMediaDueDivide;
    }

    public Long getHzMediaDueDivide() 
    {
        return hzMediaDueDivide;
    }
    public void setHegsMediaDueDivide(Long hegsMediaDueDivide) 
    {
        this.hegsMediaDueDivide = hegsMediaDueDivide;
    }

    public Long getHegsMediaDueDivide() 
    {
        return hegsMediaDueDivide;
    }
    public void setPayLaunchPv(Long payLaunchPv) 
    {
        this.payLaunchPv = payLaunchPv;
    }

    public Long getPayLaunchPv() 
    {
        return payLaunchPv;
    }
    public void setPayExposurePv(Long payExposurePv) 
    {
        this.payExposurePv = payExposurePv;
    }

    public Long getPayExposurePv() 
    {
        return payExposurePv;
    }
    public void setPayEfClicks(Long payEfClicks) 
    {
        this.payEfClicks = payEfClicks;
    }

    public Long getPayEfClicks() 
    {
        return payEfClicks;
    }
    public void setIpRequestPv(Long ipRequestPv) 
    {
        this.ipRequestPv = ipRequestPv;
    }

    public Long getIpRequestPv() 
    {
        return ipRequestPv;
    }
    public void setSlotEfRequestPv(Long slotEfRequestPv) 
    {
        this.slotEfRequestPv = slotEfRequestPv;
    }

    public Long getSlotEfRequestPv() 
    {
        return slotEfRequestPv;
    }
    public void setNewRequestUv(Long newRequestUv) 
    {
        this.newRequestUv = newRequestUv;
    }

    public Long getNewRequestUv() 
    {
        return newRequestUv;
    }
    public void setAdvertRequestCountHd(Long advertRequestCountHd) 
    {
        this.advertRequestCountHd = advertRequestCountHd;
    }

    public Long getAdvertRequestCountHd() 
    {
        return advertRequestCountHd;
    }
    public void setAdvertRequestCountZs(Long advertRequestCountZs) 
    {
        this.advertRequestCountZs = advertRequestCountZs;
    }

    public Long getAdvertRequestCountZs() 
    {
        return advertRequestCountZs;
    }
    public void setLaunchCountHd(Long launchCountHd) 
    {
        this.launchCountHd = launchCountHd;
    }

    public Long getLaunchCountHd() 
    {
        return launchCountHd;
    }
    public void setLaunchCountZs(Long launchCountZs) 
    {
        this.launchCountZs = launchCountZs;
    }

    public Long getLaunchCountZs() 
    {
        return launchCountZs;
    }
    public void setPayLaunchHd(Long payLaunchHd) 
    {
        this.payLaunchHd = payLaunchHd;
    }

    public Long getPayLaunchHd() 
    {
        return payLaunchHd;
    }
    public void setPayLaunchZs(Long payLaunchZs) 
    {
        this.payLaunchZs = payLaunchZs;
    }

    public Long getPayLaunchZs() 
    {
        return payLaunchZs;
    }
    public void setAdvertExposureCountHd(Long advertExposureCountHd) 
    {
        this.advertExposureCountHd = advertExposureCountHd;
    }

    public Long getAdvertExposureCountHd() 
    {
        return advertExposureCountHd;
    }
    public void setAdvertExposureCountZs(Long advertExposureCountZs) 
    {
        this.advertExposureCountZs = advertExposureCountZs;
    }

    public Long getAdvertExposureCountZs() 
    {
        return advertExposureCountZs;
    }
    public void setAdvertClickCountHd(Long advertClickCountHd) 
    {
        this.advertClickCountHd = advertClickCountHd;
    }

    public Long getAdvertClickCountHd() 
    {
        return advertClickCountHd;
    }
    public void setAdvertClickCountZs(Long advertClickCountZs) 
    {
        this.advertClickCountZs = advertClickCountZs;
    }

    public Long getAdvertClickCountZs() 
    {
        return advertClickCountZs;
    }
    public void setAdConsumeHd(Long adConsumeHd) 
    {
        this.adConsumeHd = adConsumeHd;
    }

    public Long getAdConsumeHd() 
    {
        return adConsumeHd;
    }
    public void setAdConsumeZs(Long adConsumeZs) 
    {
        this.adConsumeZs = adConsumeZs;
    }

    public Long getAdConsumeZs() 
    {
        return adConsumeZs;
    }
    public void setSlotAccessType(Integer slotAccessType) 
    {
        this.slotAccessType = slotAccessType;
    }

    public Integer getSlotAccessType() 
    {
        return slotAccessType;
    }
    public void setCashConsume(BigDecimal cashConsume) 
    {
        this.cashConsume = cashConsume;
    }

    public BigDecimal getCashConsume() 
    {
        return cashConsume;
    }
    public void setHzCashConsume(BigDecimal hzCashConsume) 
    {
        this.hzCashConsume = hzCashConsume;
    }

    public BigDecimal getHzCashConsume() 
    {
        return hzCashConsume;
    }
    public void setHegsCashConsume(BigDecimal hegsCashConsume) 
    {
        this.hegsCashConsume = hegsCashConsume;
    }

    public BigDecimal getHegsCashConsume() 
    {
        return hegsCashConsume;
    }
    public void setHcdjAdConsume(Long hcdjAdConsume) 
    {
        this.hcdjAdConsume = hcdjAdConsume;
    }

    public Long getHcdjAdConsume() 
    {
        return hcdjAdConsume;
    }
    public void setHcdjExConsumeTotal(Long hcdjExConsumeTotal) 
    {
        this.hcdjExConsumeTotal = hcdjExConsumeTotal;
    }

    public Long getHcdjExConsumeTotal() 
    {
        return hcdjExConsumeTotal;
    }
    public void setHcdjConsumeTotal(Long hcdjConsumeTotal) 
    {
        this.hcdjConsumeTotal = hcdjConsumeTotal;
    }

    public Long getHcdjConsumeTotal() 
    {
        return hcdjConsumeTotal;
    }
    public void setHcdjMediaExDivide(Long hcdjMediaExDivide) 
    {
        this.hcdjMediaExDivide = hcdjMediaExDivide;
    }

    public Long getHcdjMediaExDivide() 
    {
        return hcdjMediaExDivide;
    }
    public void setHcdjMediaDueDivide(Long hcdjMediaDueDivide) 
    {
        this.hcdjMediaDueDivide = hcdjMediaDueDivide;
    }

    public Long getHcdjMediaDueDivide() 
    {
        return hcdjMediaDueDivide;
    }
    public void setHcdjCashConsume(BigDecimal hcdjCashConsume) 
    {
        this.hcdjCashConsume = hcdjCashConsume;
    }

    public BigDecimal getHcdjCashConsume() 
    {
        return hcdjCashConsume;
    }
    public void setRequestCount(Long requestCount) 
    {
        this.requestCount = requestCount;
    }

    public Long getRequestCount() 
    {
        return requestCount;
    }
    public void setSendCount(Long sendCount) 
    {
        this.sendCount = sendCount;
    }

    public Long getSendCount() 
    {
        return sendCount;
    }
    public void setSdkUvOriginal(Long sdkUvOriginal) 
    {
        this.sdkUvOriginal = sdkUvOriginal;
    }

    public Long getSdkUvOriginal() 
    {
        return sdkUvOriginal;
    }
    public void setSlotEfRequestPvOriginal(Long slotEfRequestPvOriginal) 
    {
        this.slotEfRequestPvOriginal = slotEfRequestPvOriginal;
    }

    public Long getSlotEfRequestPvOriginal() 
    {
        return slotEfRequestPvOriginal;
    }
    public void setNewRequestUvOriginal(Long newRequestUvOriginal) 
    {
        this.newRequestUvOriginal = newRequestUvOriginal;
    }

    public Long getNewRequestUvOriginal() 
    {
        return newRequestUvOriginal;
    }
    public void setIpRequestPvOriginal(Long ipRequestPvOriginal) 
    {
        this.ipRequestPvOriginal = ipRequestPvOriginal;
    }

    public Long getIpRequestPvOriginal() 
    {
        return ipRequestPvOriginal;
    }
    public void setAdConsumeOriginal(Long adConsumeOriginal) 
    {
        this.adConsumeOriginal = adConsumeOriginal;
    }

    public Long getAdConsumeOriginal() 
    {
        return adConsumeOriginal;
    }
    public void setHzAdConsumeOriginal(Long hzAdConsumeOriginal) 
    {
        this.hzAdConsumeOriginal = hzAdConsumeOriginal;
    }

    public Long getHzAdConsumeOriginal() 
    {
        return hzAdConsumeOriginal;
    }
    public void setHegsAdConsumeOriginal(Long hegsAdConsumeOriginal) 
    {
        this.hegsAdConsumeOriginal = hegsAdConsumeOriginal;
    }

    public Long getHegsAdConsumeOriginal() 
    {
        return hegsAdConsumeOriginal;
    }
    public void setHcdjAdConsumeOriginal(Long hcdjAdConsumeOriginal) 
    {
        this.hcdjAdConsumeOriginal = hcdjAdConsumeOriginal;
    }

    public Long getHcdjAdConsumeOriginal() 
    {
        return hcdjAdConsumeOriginal;
    }
    public void setCashConsumeOriginal(BigDecimal cashConsumeOriginal) 
    {
        this.cashConsumeOriginal = cashConsumeOriginal;
    }

    public BigDecimal getCashConsumeOriginal() 
    {
        return cashConsumeOriginal;
    }
    public void setSdkPvOriginal(Long sdkPvOriginal) 
    {
        this.sdkPvOriginal = sdkPvOriginal;
    }

    public Long getSdkPvOriginal() 
    {
        return sdkPvOriginal;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("mediaId", getMediaId())
            .append("appId", getAppId())
            .append("appName", getAppName())
            .append("platform", getPlatform())
            .append("slotId", getSlotId())
            .append("slotName", getSlotName())
            .append("slotType", getSlotType())
            .append("slotMsId", getSlotMsId())
            .append("actExposeCount", getActExposeCount())
            .append("actClickCount", getActClickCount())
            .append("actClickUv", getActClickUv())
            .append("actClickRate", getActClickRate())
            .append("actRequestUv", getActRequestUv())
            .append("actRequestCount", getActRequestCount())
            .append("participateCount", getParticipateCount())
            .append("participateUv", getParticipateUv())
            .append("actParticipateRate", getActParticipateRate())
            .append("rptParticipateCount", getRptParticipateCount())
            .append("advertRequestCount", getAdvertRequestCount())
            .append("launchCount", getLaunchCount())
            .append("requestSuccessRate", getRequestSuccessRate())
            .append("launchSuccessRate", getLaunchSuccessRate())
            .append("advertExposureCount", getAdvertExposureCount())
            .append("advertClickCount", getAdvertClickCount())
            .append("advertClickRate", getAdvertClickRate())
            .append("advertPerClickFee", getAdvertPerClickFee())
            .append("arpu", getArpu())
            .append("spm", getSpm())
            .append("ecpm", getEcpm())
            .append("actPerRequestFee", getActPerRequestFee())
            .append("actPerClickFee", getActPerClickFee())
            .append("adConsume", getAdConsume())
            .append("exConsumeTotal", getExConsumeTotal())
            .append("consumeTotal", getConsumeTotal())
            .append("curDate", getCurDate())
            .append("gmtCreate", getGmtCreate())
            .append("gmtModified", getGmtModified())
            .append("efClickCount", getEfClickCount())
            .append("advertClickCountUv", getAdvertClickCountUv())
            .append("liuliangPv", getLiuliangPv())
            .append("liuliangUv", getLiuliangUv())
            .append("sdkPv", getSdkPv())
            .append("sdkUv", getSdkUv())
            .append("resource", getResource())
            .append("actSucResponseCount", getActSucResponseCount())
            .append("highriskLaunch", getHighriskLaunch())
            .append("mediaExDivide", getMediaExDivide())
            .append("mediaDueDivide", getMediaDueDivide())
            .append("logicalConsume", getLogicalConsume())
            .append("actExposeUv", getActExposeUv())
            .append("hzAdConsume", getHzAdConsume())
            .append("hegsAdConsume", getHegsAdConsume())
            .append("hzExConsumeTotal", getHzExConsumeTotal())
            .append("hegsExConsumeTotal", getHegsExConsumeTotal())
            .append("hzConsumeTotal", getHzConsumeTotal())
            .append("hegsConsumeTotal", getHegsConsumeTotal())
            .append("hzMediaExDivide", getHzMediaExDivide())
            .append("hegsMediaExDivide", getHegsMediaExDivide())
            .append("hzMediaDueDivide", getHzMediaDueDivide())
            .append("hegsMediaDueDivide", getHegsMediaDueDivide())
            .append("payLaunchPv", getPayLaunchPv())
            .append("payExposurePv", getPayExposurePv())
            .append("payEfClicks", getPayEfClicks())
            .append("ipRequestPv", getIpRequestPv())
            .append("slotEfRequestPv", getSlotEfRequestPv())
            .append("newRequestUv", getNewRequestUv())
            .append("advertRequestCountHd", getAdvertRequestCountHd())
            .append("advertRequestCountZs", getAdvertRequestCountZs())
            .append("launchCountHd", getLaunchCountHd())
            .append("launchCountZs", getLaunchCountZs())
            .append("payLaunchHd", getPayLaunchHd())
            .append("payLaunchZs", getPayLaunchZs())
            .append("advertExposureCountHd", getAdvertExposureCountHd())
            .append("advertExposureCountZs", getAdvertExposureCountZs())
            .append("advertClickCountHd", getAdvertClickCountHd())
            .append("advertClickCountZs", getAdvertClickCountZs())
            .append("adConsumeHd", getAdConsumeHd())
            .append("adConsumeZs", getAdConsumeZs())
            .append("slotAccessType", getSlotAccessType())
            .append("cashConsume", getCashConsume())
            .append("hzCashConsume", getHzCashConsume())
            .append("hegsCashConsume", getHegsCashConsume())
            .append("hcdjAdConsume", getHcdjAdConsume())
            .append("hcdjExConsumeTotal", getHcdjExConsumeTotal())
            .append("hcdjConsumeTotal", getHcdjConsumeTotal())
            .append("hcdjMediaExDivide", getHcdjMediaExDivide())
            .append("hcdjMediaDueDivide", getHcdjMediaDueDivide())
            .append("hcdjCashConsume", getHcdjCashConsume())
            .append("requestCount", getRequestCount())
            .append("sendCount", getSendCount())
            .append("sdkUvOriginal", getSdkUvOriginal())
            .append("slotEfRequestPvOriginal", getSlotEfRequestPvOriginal())
            .append("newRequestUvOriginal", getNewRequestUvOriginal())
            .append("ipRequestPvOriginal", getIpRequestPvOriginal())
            .append("adConsumeOriginal", getAdConsumeOriginal())
            .append("hzAdConsumeOriginal", getHzAdConsumeOriginal())
            .append("hegsAdConsumeOriginal", getHegsAdConsumeOriginal())
            .append("hcdjAdConsumeOriginal", getHcdjAdConsumeOriginal())
            .append("cashConsumeOriginal", getCashConsumeOriginal())
            .append("sdkPvOriginal", getSdkPvOriginal())
            .toString();
    }
}
