package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivityGroupDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivitySortDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqActivitySort;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqIdAndType;
import cn.com.duiba.tuia.ssp.center.api.dto.RspActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.stringtemplate.v4.ST;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
@AdvancedFeignClient
public interface RemoteActivitySortBackendService {

    /**
     * getByCondition:(查询活动列表接口). <br/>
     *
     * @author ZFZ
     * @param reqActivitySort
     * @return
     * @since JDK 1.6
     */
    DubboResult<PageResultDto<RspActivityDto>> getByCondition(ReqActivitySort reqActivitySort, Map<Integer,String> actTypeMap);


    List<RspActivityDto> listByCondition(ReqActivitySort reqActivitySort, Map<Integer,String> actTypeMap);
    
    //查询活动组活动列表
    DubboResult<PageResultDto<RspActivityDto>> ListActGroup(ReqActivitySort reqActivitySort, Map<Integer,String> actTypeMap);  //NOSONAR 接口暂不修改
    
    //管理活动组页面活动列表
    DubboResult<List<RspActivityDto>> ListActGroupById(Long groupId, Map<Integer,String> actTypeMap);   //NOSONAR 接口暂不修改
    
    //new 管理活动组页面活动列表
    List<RspActivityDto> newListActGroupById(Long groupId, Map<Integer,String> actTypeMap,Long msId); 

    //查询广告位下所有活动，不包含删除和未开启
    DubboResult<List<ActivityGroupDto>> listActByIdSlotId(Long slotId);

    /**
     * removeActivity:(移除活动接口). <br/>
     *
     * @author ZFZ
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param source 活动来源
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> removeActivityBySource(Long slotId, Long activityId, Integer source);
    
    //移除活动组
    DubboResult<Boolean> deleteActivityGroup(Long actGroupId, Long slotId);

    /**
     * sort:(排序接口). <br/>
     *
     * @author ZFZ
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param source 
     * @param location 位置
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> sortBySource(Long slotId, Long activityId, Integer source, int location);
    
    /**
     * 活动组排序
     * @param slotId
     * @param location 位置
     * @return
     */
    DubboResult<Boolean> sortActGroup(Long slotId, Long actGroupId, int location);

    /**
     * 给活动中心的提供的接口,获取推荐的活动ID列表
     * 
     * @param slotId 数量
     * @return
     */
    DubboResult<List<Long>> getActivityIdForCenter(Long slotId);
    
    /**
     * 获取默认列表
     * 
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getDefaultActivityList();

    /**
     * addActivitySort:(添加活动接口). <br/>
     *
     * @author ZFZ
     * @param slotId 广告位ID
     * @param idAndTypes 活动列表
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addActivitySort(Long slotId, List<ReqIdAndType> idAndTypes,Map<Integer,String> actTypeMap);
    
    /**
     * 添加活动组接口
     * @param slotId
     * @param idAndTypes
     * @param actTypeMap
     * @return
     */
    DubboResult<Boolean> addActivityGroupSort(Long slotId, List<ReqIdAndType> idAndTypes,Map<Integer,String> actTypeMap);

    /**
     * addDefaultActivitySort:(添加默认活动接口). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addDefaultActivitySort(Long slotId,Map<Integer,String> actTypeMap);
    
    /**
     * 
     * getAllActivityBySlotId:(查询该广告位下面所有的活动). <br/>
     *
     * @author guyan
     * @param slotId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<ActivitySortDto>> getAllActivityBySlotId(Long slotId);
    List<ActivitySortDto> getAllActivityBySlotIdV1(Long slotId);

    /**
     * 
     * getActivitySortByActivityId:(查询活动通过活动id). <br/>
     *
     * @author guyan
     * @param activityId
     * @param source
     * @return
     * @since JDK 1.6
     */

    DubboResult <List<ActivitySortDto>> getActivitySortByActivityId(Long activityId,Integer source);


    DubboResult<List<ActivitySortDto>> selectBySlot(Long slotId);

    /**
     * 广告位按地域添加依次投放活动
     * @param slotId
     * @param regionId
     * @param idAndTypes
     * @param actTypeMap
     * @return
     */
    int addActivitySortByRegion(Long slotId, Long regionId, List<ReqIdAndType> idAndTypes, Map<Integer, String> actTypeMap);



    /**
     * 广告位按地域添加依次投放活动区分深度互动广告位
     * @param slotId
     * @param regionId
     * @param idAndTypes
     * @param actTypeMap
     * @return
     */
    int addActivitySortByRegionDistinguishDeep(Long slotId, Long regionId, List<ReqIdAndType> idAndTypes, Map<Integer, String> actTypeMap,Map<String,Object> deepMap);


    int addActivitySortByRegionDistinguishDeepV1(Long slotId, Long regionId, Byte belongToGroup,
            List<ReqIdAndType> idAndTypes,Map<Integer, String> actTypeMap, Map<String,Object> deepMap);

    /**
     * 按地域添加活动组接口
     * @param slotId
     * @param regionId
     * @param idAndTypes
     * @param actTypeMap
     * @return
     */
    int addActivityGroupSortByRegion(Long slotId, Long regionId, List<ReqIdAndType> idAndTypes,Map<Integer,String> actTypeMap);

    int addActivityGroupSortByRegionV1(Long slotId, Long regionId, Byte belongToGroup,
            List<ReqIdAndType> idAndTypes, Map<Integer, String> actTypeMap);

    int addActivityGroupSortByRegionV2(Long slotId, Long regionId, Byte belongToGroup,
                                       List<ReqIdAndType> idAndTypes, Map<Integer, String> actTypeMap);

    /**
     * 依次投放活动--移除活动
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param source 活动来源
     * @param regionId 地域类型ID
     * @return
     */
    Boolean removeActivityBySourceAndRegion(Long slotId, Long activityId, Integer source, Long regionId);

    Boolean removeActivityBySourceAndRegionV1(Long slotId, Long activityId, Integer source,
            Long regionId,Byte belongToGroup);

    /**
     * 依次投放活动--移除活动
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param source 活动来源
     * @param regionId 地域类型ID
     * @return
     */
    Boolean removeActivityBySourceAndRegionAndDistinguishDeep(Long slotId, Long activityId, Integer source, Long regionId, Map<String,Object> deepMap);

    Boolean removeActivityBySourceAndRegionAndDistinguishDeepV1(Long slotId, Long activityId,
            Integer source, Long regionId,Byte belongToGroup, Map<String,Object> deepMap);

    /**
     * 按地域移除活动组
     * @param actGroupId 活动组ID
     * @param slotId 广告位ID
     * @param regionId 地域类型ID
     * @return
     */
    Boolean deleteActivityGroupByRegion(Long actGroupId, Long slotId, Long regionId);
    Boolean deleteActivityGroupByRegionV1(Long actGroupId, Long slotId, Long regionId,Byte belongToGroup);
    /**
     * sort:(按地域依次投放活动排序接口)
     * @param slotId 广告位ID
     * @param regionId 地域类型ID
     * @param activityId 活动ID
     * @param source 来源
     * @param location 位置
     * @return
     */
    Boolean sortBySourceAndRegion(Long slotId, Long regionId, Long activityId, Integer source, int location);

    Boolean sortBySourceAndRegionV1(Long slotId, Long regionId,Byte belongToGroup,
            Long activityId,Integer source, int location);

    /**
     * 按地域活动组排序
     * @param slotId 广告位ID
     * @param regionId 地域类型ID
     * @param actGroupId 活动组ID
     * @param location 位置
     * @return
     */
    Boolean sortActGroupByRegion(Long slotId, Long regionId, Long actGroupId, int location);

    Boolean sortActGroupByRegionV1(Long slotId, Long regionId,Byte belongToGroup, Long actGroupId,
            int location);
}
