package cn.com.duiba.tuia.ssp.center.api.remote.industryPenetration.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.List;

/**
 * 行业类别
 * @dateTime 2020-07-13 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class CategoryVo implements Serializable {

    /**
     * Id
     */
    private Long id;

    /**
     * 名称
     */
    private String name;

    /**
     * 父·Id
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Long pid;

    /**
     * 子·类别
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private List<CategoryVo> sub;

}