package cn.com.duiba.tuia.ssp.center.api.constant.ocpx;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2022/4/21
 * 策略ID 1-多O概率上报 2-单资源概率上报 3-直接上报
 * @Description
 * @Param
 * @return
 **/
@Getter
public enum StrategyReportTypeEnum {
    /**
     * 多O概率上报
     */
    MULTIPLE_O_PROBABILITY_REPORT(1, "多O概率上报"),
    /**
     * 单资源概率上报
     */
    SINGLE_RESOURCE_PROBABILITY_REPORTING(2, "单资源概率上报"),
    /**
     * 直接上报
     */
    REPORT_DIRECTLY(3, "直接上报"),
    /**
     * 固定收益上报
     */
    FIXED_INCOME(4, "固定收益上报"),
    /**
     * 固定收益-自定义上报
     */
    FIXED_INCOME_CUSTOMIZE(5, "固定收益-自定义上报"),
    /**
     * 概率上报2.0
     */
    PROBABILITY_ACCURATE_REPORT(6, "多O概率上报2.0"),
    /**
     * 固定理论收益上报
     */
    THEORETICAL_INCOME_REPORT(7, "固定理论收益上报"),
    /**
     * 固定理论收益-自定义上报
     */
    THEORETICAL_INCOME_CUSTOM_REPORT(8, "固定理论收益-自定义上报"),

    ;

    private Integer strategyId;

    private String desc;

    StrategyReportTypeEnum(Integer strategyId, String desc){
        this.strategyId = strategyId;
        this.desc = desc;
    }

    public static String getDescByStrategyId(Integer strategyId){
        for (StrategyReportTypeEnum strategyReportTypeEnum : StrategyReportTypeEnum. values()){
            if(strategyReportTypeEnum.getStrategyId().equals(strategyId)){
                return strategyReportTypeEnum.getDesc();
            }
        }
        return "";
    }

}
