package cn.com.duiba.tuia.ssp.center.api.params;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ProgrammaticMediaReportConfigDTO;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2022/4/11
 * @Description
 * @Param
 * @return
 **/
@Data
public class ProgrammaticMediaReportReq extends BaseQueryDto{
    private Long id;
    /**
     * 广告位id
     */
    @NotNull(message = "广告位ID不能为空")
    private Long slotId;
    /**
     * 广告位名称
     */
    private String slotName;
    /**
     * 媒体id
     */
    private Long appId;
    /**
     * 媒体名称
     */
    private String appName;
    /**
     * 平台id
     */
    @NotNull(message = "平台不能为空")
    private Integer mediaPlatform;
    /**
     * 账户id
     */
    private String accountId;
    /**
     * 策略id
     */
    @NotNull(message = "策略不能为空")
    private Integer strategyId;
    /**
     * 备注
     */
    @Length(max = 100, message = "备注内容不能超过100个字")
    private String remark;
    /**
     * 配置列表
     */
    private List<ProgrammaticMediaReportConfigDTO> reportConfigList;
    /**
     * 操作人id
     */
    private Long operateId;

    /**
     * vivo srcId
     */
    private String srcId;

    private String extendValue;

    /**
     * 360 key
     */
    private String api360Key;
    /**
     * 360 secret
     */
    private String api360Secret;
    /**
     * 万能wifi钥匙 客户ID
     */
    private String wnClientId;

    /**
     * 万能wifi钥匙 签名密钥
     */
    private String wnSecretkey;

    /**
     * vivo clientId
     */
    private String clientId;
    /**
     * vivo clientSecret
     */
    private String clientSecret;
    /**
     * 收益
     */
    private Long income;
    /**
     * oppo api_id
     */
    private String apiId;
    /**
     * oppo api_key
     */
    private String apiKey;

}
