package cn.com.duiba.tuia.ssp.center.api.remote.media.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * Result 枚举
 * @dateTime 2019-11-19 11:51:27
 * @author haitao.hua
 */
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = true, chain = true, prefix = "")
public enum ResultEnum {

    /*################################# Result 的枚举 ( Start ) #####################################*/

    Success(0, "成功"),
    Failure(500, "失败");

    /*################################# Result 的枚举 ( end ) #######################################*/

    /**
     * 标识码
     */
    @Getter
    private Integer code;

    /**
     * 备注
     */
    @Getter
    private String remark;

    /**
     * Seek 值
     * @param code 标识码
     * @return 结果
     */
    public static ResultEnum seekValue(Integer code) {
        Optional<ResultEnum> result = Arrays.stream(ResultEnum.values()).filter(target -> (Objects.nonNull(target) && target.code.equals(code))).findFirst();
        return result.orElse(null);
    }

}
