package cn.com.duiba.tuia.ssp.center.api.remote.media.dto.meituan.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * 分页响应 Response
 * @dateTime 2019-11-19 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class PagingResponse<T> implements Serializable {

    /**
     * 当前页码
     */
    private Integer page;

    /**
     * 每页条数
     */
    private Integer size;

    /**
     * 总记录数
     */
    private Integer totalCount;

    /**
     * 总页数
     */
    private Integer totalPage;

    /**
     * 数据信息
     */
    private List<T> list;


    public PagingResponse(List<T> data, int count, int size, Integer page) {
        int totalPage = (count % size) > 0 ? (count / size + 1) : (count / size);
        this.page = (page > totalPage) ? totalPage : page;
        this.size = size;
        this.totalPage = totalPage;
        this.totalCount = count;
        this.list = data;
    }

    public PagingResponse(Integer page, Integer size) {
        this.page = Optional.ofNullable(page).orElseGet(() -> 1);
        this.size = Optional.ofNullable(size).orElseGet(() -> 20);
        this.totalPage = 0;
        this.totalCount = 0;
        this.list = new ArrayList<>();
    }

}
