package cn.com.duiba.tuia.ssp.center.api.dto.activity.plan;

import cn.com.duiba.tuia.ssp.center.api.constant.ActivityTypeConstant;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqIdAndType;
import com.alibaba.fastjson.JSON;

import java.io.Serializable;
import java.util.List;

/**
 * 活动定制广告请求
 *
 * @author ikongyi
 */
public class CustomAdvertReq implements Serializable {

    private static final long serialVersionUID = 6479251845601280148L;
    /**
     * 活动ID
     */
    private Long id;

    /**
     * 活动类型
     * @see ActivityTypeConstant
     */
    private Integer type;

    /**
     * 活动来源：0-兑吧活动 1-推啊活动 2-流量引导页 20 游戏 21 游戏大厅
     * @see ReqIdAndType#REQ_ACT_SOURCE_TUIA
     * @see ReqIdAndType#REQ_ACT_SOURCE_DUIBA
     */
    private Integer source;

    /**
     * 定向状态：0=未定向、1=定向
     */
    private Integer directStatus;

    /**
     * 定向模式：1=仅投放定制广告券列表、2=优先投放定制广告券列表
     */
    private Integer directMode;

    /**
     * 是否固定顺序广告：0=否、1=是
     */
    private Integer isFixedOrderAdvert;

    /**
     * 广告ID列表
     */
    private List<Long> advertIds;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public Integer getDirectStatus() {
        return directStatus;
    }

    public void setDirectStatus(Integer directStatus) {
        this.directStatus = directStatus;
    }

    public Integer getDirectMode() {
        return directMode;
    }

    public void setDirectMode(Integer directMode) {
        this.directMode = directMode;
    }

    public Integer getIsFixedOrderAdvert() {
        return isFixedOrderAdvert;
    }

    public void setIsFixedOrderAdvert(Integer isFixedOrderAdvert) {
        this.isFixedOrderAdvert = isFixedOrderAdvert;
    }

    public List<Long> getAdvertIds() {
        return advertIds;
    }

    public void setAdvertIds(List<Long> advertIds) {
        this.advertIds = advertIds;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
