package cn.com.duiba.tuia.ssp.center.api.params;

import cn.com.duiba.tuia.ssp.center.api.annotation.FieldCheck;
import lombok.Data;

/**
 * @author K. L. Mao
 * @create 2019-12-11
 */
@Data
public class SdkPutConfigUpdateParam {

    /**
     * sdk 投放配置ID
     */
    @FieldCheck(notNull = true)
    private Long configId;

    /**
     * 是否收集用户信息 0：否；1：是
     */
    @FieldCheck(notNull = true)
    private Integer isCollectUserInfo;

    /**
     * 是否支持下载器能力 0：否；1：是
     */
    @FieldCheck(notNull = true)
    private Integer isSupportDownload;

    /**
     * 是否支持关闭 0：否；1：是
     */
    @FieldCheck(notNull = true)
    private Integer isSupportClose;

    /**
     * 是否支持文件缓冲采集 0：否；1：是
     */
    @FieldCheck(notNull = true)
    private Integer isSupportFileCache;

    /**
     * 是否支持活动页面预加载 0=不支持,1=支持
     */
    @FieldCheck(notNull = true)
    private Integer isActPagePreloading;
}
