package cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord.params;

import cn.com.duiba.wolf.utils.DateUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;
import java.io.Serializable;
import java.util.Date;

/**
 * { 保存 } 流转信息 Params
 * @dateTime 2020-12-08 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class SavingCirculationParams implements Serializable {


    /**
     * The id.
     */
    @ApiModelProperty(value = "The id.", required = true)
    private Long id;

    /**
     * 请款日期 ( 格式: yyyy-MM-dd )
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "请款日期", required = false)
    private String paymentDate;

    /**
     * 打款日期 ( 格式: yyyy-MM-dd )
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "打款日期", required = false)
    private String payDate;

    /**
     * 收票日期 ( 格式: yyyy-MM-dd )
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "收票日期", required = false)
    private String invoiceReceiveDate;

    /**
     * 流转状态
     * - { 0 : 媒介助理, 1 : 已提交财务 }
     */
    @ApiModelProperty(value = "流转状态: { 0 : 媒介助理, 1 : 已提交财务 }", required = false)
    private Integer circulationStatus;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", required = false)
    private String remark;

}