/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

public class DateUtils {
    public static final long ONE_DAY_SECONDS = 86400L;
    public static final long ONE_DAY_MILL_SECONDS = 86400000L;
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String CHINESE_DATE_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String yyyyMMdd = "yyyyMMdd";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";

    public static Date getCurrentDate() {
        return new Date();
    }

    public static int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    public static Date getFirstDayOfCurrentYear() {
        Calendar ca = Calendar.getInstance();
        int currentYear = ca.get(1);
        ca.clear();
        ca.set(1, currentYear);
        return ca.getTime();
    }

    public static Date getLastDayOfCurrentYear() {
        Calendar ca = Calendar.getInstance();
        int currentYear = ca.get(1);
        ca.clear();
        ca.set(1, currentYear);
        ca.roll(6, -1);
        ca.set(11, 23);
        ca.set(12, 59);
        ca.set(13, 59);
        return ca.getTime();
    }

    public static DateFormat getNewDateFormat(String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setLenient(false);
        return df;
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static Date parseDateNoTime(String sDate, String format) throws ParseException {
        if (StringUtils.isBlank((String)format)) {
            throw new ParseException("Null format. ", 0);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        if (sDate == null || sDate.length() < format.length()) {
            throw new ParseException("length too little", 0);
        }
        return dateFormat.parse(sDate);
    }

    public static Date parseDateNewFormat(String sDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_FORMAT);
        Date d = null;
        dateFormat.setLenient(false);
        if (sDate != null && sDate.length() == DEFAULT_FORMAT.length()) {
            try {
                d = dateFormat.parse(sDate);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return d;
    }

    public static Date parseDate(String sDate, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date d = null;
        dateFormat.setLenient(false);
        if (sDate != null && sDate.length() == format.length()) {
            try {
                d = dateFormat.parse(sDate);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return d;
    }

    public static Date addHours(Date date, long hours) {
        return DateUtils.addMinutes(date, hours * 60L);
    }

    public static Date addMinutes(Date date, long minutes) {
        return DateUtils.addSeconds(date, minutes * 60L);
    }

    public static Date addSeconds(Date date, long secs) {
        return new Date(date.getTime() + secs * 1000L);
    }

    public static Date addMonths(Date date, int months) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        cl.add(2, months);
        date = cl.getTime();
        return date;
    }

    public static boolean isValidHour(String hourStr) {
        int hour;
        return !StringUtils.isEmpty((String)hourStr) && StringUtils.isNumeric((String)hourStr) && (hour = new Integer(hourStr).intValue()) >= 0 && hour <= 23;
    }

    public static boolean isValidMinuteOrSecond(String str) {
        int hour;
        return !StringUtils.isEmpty((String)str) && StringUtils.isNumeric((String)str) && (hour = new Integer(str).intValue()) >= 0 && hour <= 59;
    }

    public static Date addDays(Date date1, long days) {
        return DateUtils.addSeconds(date1, days * 86400L);
    }

    public static String getNewFormatDateString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_FORMAT);
        return DateUtils.getDateString(date, dateFormat);
    }

    public static String getDateString(Date date, DateFormat dateFormat) {
        if (date == null || dateFormat == null) {
            return null;
        }
        return dateFormat.format(date);
    }

    public static String getChineseDateString(Date date) {
        DateFormat dateFormat = DateUtils.getNewDateFormat(CHINESE_DATE_FORMAT);
        return DateUtils.getDateString(date, dateFormat);
    }

    public static long getDiffSeconds(Date one, Date two) {
        GregorianCalendar sysDate = new GregorianCalendar();
        sysDate.setTime(one);
        GregorianCalendar failDate = new GregorianCalendar();
        failDate.setTime(two);
        return (sysDate.getTimeInMillis() - failDate.getTimeInMillis()) / 1000L;
    }

    public static long getDiffMinutes(Date one, Date two) {
        GregorianCalendar sysDate = new GregorianCalendar();
        sysDate.setTime(one);
        GregorianCalendar failDate = new GregorianCalendar();
        failDate.setTime(two);
        return (sysDate.getTimeInMillis() - failDate.getTimeInMillis()) / 60000L;
    }

    public static long getDiffDays(Date after, Date before) {
        GregorianCalendar sysDate = new GregorianCalendar();
        sysDate.setTime(after);
        GregorianCalendar failDate = new GregorianCalendar();
        failDate.setTime(before);
        return (sysDate.getTimeInMillis() - failDate.getTimeInMillis()) / 86400000L;
    }

    public static long getDiffDays2(Date before, Date after) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(before);
        c1.set(11, 0);
        c1.set(12, 0);
        c1.set(13, 0);
        c1.set(14, 0);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(after);
        c2.set(11, 0);
        c2.set(12, 0);
        c2.set(13, 0);
        c2.set(14, 0);
        return (c2.getTimeInMillis() - c1.getTimeInMillis()) / 86400000L;
    }

    public static String convert(String dateString, DateFormat formatIn, DateFormat formatOut) {
        try {
            Date date = formatIn.parse(dateString);
            return formatOut.format(date);
        }
        catch (ParseException e) {
            return "";
        }
    }

    public static boolean dateNotLessThan(String date1, String date2, DateFormat format) {
        try {
            Date d1 = format.parse(date1);
            Date d2 = format.parse(date2);
            return !d1.before(d2);
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static String formatTimeRange(Date startDate, Date endDate, String format) {
        if (endDate == null || startDate == null) {
            return null;
        }
        String rt = null;
        long range = endDate.getTime() - startDate.getTime();
        long day = range / 86400000L;
        long hour = range % 86400000L / 3600000L;
        long minute = range % 3600000L / 60000L;
        if (range < 0L) {
            day = 0L;
            hour = 0L;
            minute = 0L;
        }
        rt = format.replaceAll("dd", String.valueOf(day));
        rt = rt.replaceAll("hh", String.valueOf(hour));
        rt = rt.replaceAll("mm", String.valueOf(minute));
        return rt;
    }

    public static Date getBeforeDate() {
        return new Date(System.currentTimeMillis() - 86400000L);
    }

    public static Date getDayBegin(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(yyyyMMdd);
        df.setLenient(false);
        String dateString = df.format(date);
        try {
            return df.parse(dateString);
        }
        catch (ParseException e) {
            return date;
        }
    }

    public static boolean dateLessThanNowAddMin(Date date, long min) {
        return DateUtils.addMinutes(date, min).before(new Date());
    }

    public static boolean isBeforeNow(Date date) {
        if (date == null) {
            return false;
        }
        return date.compareTo(new Date()) < 0;
    }

    public static Date getFutureDay(int days) {
        try {
            Calendar calendar = GregorianCalendar.getInstance();
            Date date = calendar.getTime();
            calendar.setTime(date);
            calendar.add(5, days);
            return calendar.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getFixDayFutureDay(Date fixDay, int days) {
        try {
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(fixDay);
            calendar.add(5, days);
            return calendar.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getFixYearFutureYear(Date date, int years) {
        try {
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(date);
            calendar.add(1, 1);
            return calendar.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean betweenStartAndEndDate(Date fixDate, Date startDate, Date endDate) {
        if (null == fixDate) {
            fixDate = new Date();
        }
        return fixDate.before(endDate) && fixDate.after(startDate);
    }

    public static String getWeekOfDate(Date dt) {
        String[] weekDays = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
        return DateUtils.getWeekOfDate(dt, weekDays);
    }

    public static String getWeekOfDate(Date dt, String[] weekDays) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static int getDateAsInt(Date date) {
        String s = new SimpleDateFormat(yyyyMMdd).format(date);
        return Integer.parseInt(s);
    }

    public static Integer getDateAsInteger(Date date) {
        if (date == null) {
            return null;
        }
        String s = new SimpleDateFormat(yyyyMMdd).format(date);
        return Integer.parseInt(s);
    }

    public static int date10To8(String date) {
        String s = date.replace("-", "");
        return Integer.parseInt(s);
    }

    public static Date getIntAsDate(Integer date) {
        if (date == null) {
            return null;
        }
        try {
            String dateString = date.toString();
            if (dateString.length() != 8) {
                throw new IllegalArgumentException("date:" + date + " is invalid!");
            }
            return new SimpleDateFormat(yyyyMMdd).parse(date.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDateWithoutTime(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(yyyyMMdd);
        String s = fmt.format(date);
        try {
            return fmt.parse(s);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getDateWithFixFormatter(Date date, String formatStr) {
        SimpleDateFormat df = new SimpleDateFormat(formatStr);
        df.setLenient(false);
        String dateString = df.format(date);
        try {
            return df.parse(dateString);
        }
        catch (ParseException e) {
            return date;
        }
    }

    public static Date getNextTwoAm(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, 1);
        c.set(11, 2);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    public static Integer addDates(Integer date, int days) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat yyyyMMdd = new SimpleDateFormat(yyyyMMdd);
        try {
            Date beginDate = yyyyMMdd.parse(String.valueOf(date));
            return DateUtils.getDateAsInt(org.apache.commons.lang.time.DateUtils.addDays((Date)beginDate, (int)days));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDayLastMill(Date date) {
        if (date == null) {
            return null;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getSpecifiedDate(String formatStr, String dateStr) {
        if (dateStr == null) {
            return null;
        }
        Date date = null;
        try {
            SimpleDateFormat format = new SimpleDateFormat(formatStr);
            date = format.parse(dateStr);
        }
        catch (Exception e) {
            return null;
        }
        return date;
    }

    public static Integer oddSecondOfDay() {
        DateTime start = new DateTime();
        DateTime end = new DateTime().withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59);
        return Seconds.secondsBetween((ReadableInstant)start, (ReadableInstant)end).getSeconds();
    }

    public static boolean isOverlap(Date leftStartDate, Date leftEndDate, Date rightStartDate, Date rightEndDate) {
        return leftStartDate.getTime() >= rightStartDate.getTime() && leftStartDate.getTime() < rightEndDate.getTime() || leftStartDate.getTime() > rightStartDate.getTime() && leftStartDate.getTime() <= rightEndDate.getTime() || rightStartDate.getTime() >= leftStartDate.getTime() && rightStartDate.getTime() < leftEndDate.getTime() || rightStartDate.getTime() > leftStartDate.getTime() && rightStartDate.getTime() <= leftEndDate.getTime();
    }

    public static Date getDayStartTime(Date date) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getMonthEndDayTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getMonthFirstDayTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getCurrentMonthEndDayTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 0);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getCurrentonthFirstDayTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static void main(String[] args) {
        String format = "yyyy-MM-dd HH:mm:ss.SSS";
        System.out.println(DateFormatUtils.format((Date)DateUtils.getMonthEndDayTime(), (String)format));
        System.out.println(DateFormatUtils.format((Date)DateUtils.getMonthFirstDayTime(), (String)format));
        System.out.println(DateFormatUtils.format((Date)DateUtils.getCurrentMonthEndDayTime(), (String)format));
        System.out.println(DateFormatUtils.format((Date)DateUtils.getCurrentonthFirstDayTime(), (String)format));
    }
}

