package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 长期流量调整
 */
@Data
public class SlotFlowStableConfigDTO implements Serializable {

    private static final long serialVersionUID = 2551904844655956012L;

    private Long id;

    /**
     * 媒体ID
     */
    private Long appId;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 广告位名称
     */
    private String slotName;

    /**
     * 计费方式（0:分成 1:CPC 2:CPM 3:UV单价 4:CPT）
     */
    private Integer chargeType;

    /**
     * 可浮动最低比例
     */
    private Integer minRatio;

    /**
     * 可浮动最高比例
     */
    private Integer maxRatio;

    /**
     * 系统浮动后比例
     */
    private Integer currentRatio;

    /**
     * 修改时间
     */
    private Date gmtModified;
}

