package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MixMediaIncomeDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MixMediaSlotDailyStatisticsDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MixMediaConsumeDto;

import java.util.Date;
import java.util.List;

/**
 * [工具类赚钱页]媒体回流数据Remote接口
 *
 * @author zhangbaiqiang
 * @date 2020/2/10
 */
@AdvancedFeignClient
public interface RemoteMixStatisticsService {

    /**
     * 查询媒体的收益数据
     *
     * @param appId 媒体id
     * @param date  日期
     * @return 收益数据
     */
    MixMediaIncomeDto selectByAppIdAndTime(Long appId, Date date);

    /**
     * 查询媒体的广告位收益数据
     *
     * @param appId 媒体id
     * @param date  日期
     * @return 收益数据
     */
    List<MixMediaConsumeDto> selectSlotConsumeByAppIdAndTime(Long appId, Date date);

    /**
     * 批量查询媒体收益
     *
     * @param appIds
     * @param date
     * @return
     */
    List<MixMediaIncomeDto> selectByAppIdsAndCurDate(List<Long> appIds, Date date);


    Boolean saveMixMediaIncome(MixMediaSlotDailyStatisticsDto mixMediaIncomeDto);

}
