/**
 * Project Name:ssp-center-api
 * File Name:ReqUpdateFinanceDto.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年9月26日下午2:01:12
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.builder.ToStringBuilder;

import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqUpdateFinanceDto <br/>
 * Function: 修改财务信息. <br/>
 * Date:     2017年9月26日 下午2:01:12 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ReqUpdateFinanceDto implements Serializable {

    /**序列号*/
    private static final long serialVersionUID = -6251008380895188766L;


    /**媒体用户ID*/
    @ApiModelProperty(value = "媒体用户ID", required = true)
    @NotNull(message = "媒体用户ID不能为空")
    private Long mediaId;
    
    /**解锁状态*/
    @ApiModelProperty(value = "解锁状态", required = false)
    private Integer unlockStatus;
    
    /**审核状态*/
    @ApiModelProperty(value = "审核状态", required = false)
    private Integer checkStatus;
    
    /** 是否第一次提交审核 */
    @ApiModelProperty(value = "审核状态", required = false)
    private Integer           isFirstSubmit;
    
    /**审核原因*/
    @ApiModelProperty(value = "审核原因", required = false)
    private String checkMsg;

    /**
     * 开户人
     */
    private String accountOpenman;

    /**
     * 账号ID列表
     */
    private List<Long> mediaIds;
    
    public Long getMediaId() {
        return mediaId;
    }

    
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    
    public Integer getUnlockStatus() {
        return unlockStatus;
    }

    
    public void setUnlockStatus(Integer unlockStatus) {
        this.unlockStatus = unlockStatus;
    }
    
    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }
    
    public Integer getIsFirstSubmit() {
        return isFirstSubmit;
    }
    
    public void setIsFirstSubmit(Integer isFirstSubmit) {
        this.isFirstSubmit = isFirstSubmit;
    }
    
    public String getCheckMsg() {
        return checkMsg;
    }

    public void setCheckMsg(String checkMsg) {
        this.checkMsg = checkMsg;
    }

    public String getAccountOpenman() {
        return accountOpenman;
    }

    public void setAccountOpenman(String accountOpenman) {
        this.accountOpenman = accountOpenman;
    }

    public List<Long> getMediaIds() {
        return mediaIds;
    }

    public void setMediaIds(List<Long> mediaIds) {
        this.mediaIds = mediaIds;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}

