package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 风控回流建议分成价格表
 * 
 * @author YWG.MID.P
 * @date 2020-09-28 07:29:05
 */
@Data
public class SlotProposalPriceReq extends BaseQueryDto{

	/**
	 * 主键
	 */
	@ApiModelProperty(value = "主键")
	private Long id;
	/**
	 * 账号ID
	 */
	@ApiModelProperty(value = "账号ID")
	private Long mediaId;
	/**
	 * 媒体ID
	 */
	@ApiModelProperty(value = "媒体ID")
	private Long appId;
	/**
	 * 广告位ID
	 */
	@ApiModelProperty(value = "广告位ID")
	private Long slotId;
	/**
	 * 媒体名称
	 */
	@ApiModelProperty(value = "媒体名称")
	private String appName;
	/**
	 * 广告位名称
	 */
	@ApiModelProperty(value = "广告位名称")
	private String slotName;
	/**
	 * 日期
	 */
	@ApiModelProperty(value = "日期")
	private Date curDate;
	/**
	 * 预期分成价格
	 */
	@ApiModelProperty(value = "预期分成价格")
	private Long sharedExpect;
	/**
	 * 建议分成价格
	 */
	@ApiModelProperty(value = "建议分成价格")
	private Long sharedSuggest;
	/**
	 * 预期每UV单价
	 */
	@ApiModelProperty(value = "预期每UV单价")
	private Long uvPriceExpect;
	/**
	 * 建议每UV单价
	 */
	@ApiModelProperty(value = "建议每UV单价")
	private Long uvPriceSuggest;
	/**
	 * 偏离率
	 */
	@ApiModelProperty(value = "偏离率")
	private Integer deviateRate;
	/**
	 * 创建时间
	 */
	@ApiModelProperty(value = "创建时间")
	private Date gmtCreate;
	/**
	 * 修改时间
	 */
	@ApiModelProperty(value = "修改时间")
	private Date gmtModified;

	@ApiModelProperty(value = "托管开启状态:0-关闭,1-开启")
	private Integer isHosting;

	/**
	 * 预期分成比例
	 */
	@ApiModelProperty(value = "预期分成比例")
	private Integer divisionExpect;

	/**
	 * 建议分成比例
	 */
	@ApiModelProperty(value = "建议分成比例")
	private Integer divisionSuggest;

	@ApiModelProperty(value = " 价格（分）")
	private Integer price;

	@ApiModelProperty(value = "媒体分账比例：% ")
	private Integer mediaSplitRatio;

	@ApiModelProperty(value = "广告位有效点击PV")
	private Long    validActClick;

	@ApiModelProperty(value = "广告位有效曝光PV")
	private Long    validActExpose;

	@ApiModelProperty(value = "广告位曝光UV")
	private Long slotRequestUv;

	@ApiModelProperty(value = "作弊消耗占比=作弊消耗/消耗")
	private Integer cheatFeeRate;

	@ApiModelProperty(value = "昨日现金总消耗")
	private Long yesterdayCashConsume;

	@ApiModelProperty(value = " 近三日媒体uv单价均值（分）")
	private Long avgThreeUv;

	@ApiModelProperty(value = " 广告位有效访问PV")
	private Long slotEfRequestPvCount;

	/** 建议分成价格 **/
	@ApiModelProperty(value = "建议分成价格")
	private Long priceSuggest;

	/** 广告位质量分 **/
	@ApiModelProperty(value = "广告位质量分")
	private String estimateScore;

	@ApiModelProperty(value = "质量等级")
	private String estimateLevel;

	@ApiModelProperty(value = "建议计费价格")
	private String divisionPriceSuggest;

	@ApiModelProperty(value = "预计昨日媒体收入")
	private String  yesterdayExpectMediaIncome;

	@ApiModelProperty(value = "建议来源.0-仅BI、1-仅风控、2-同时BI、风控")
	private Integer suggestSource;

	/** 计费方式:0-分成;1-CPC;2-CPM,3-UV单价*/
	private Integer chargeType;

	/** 风控建议计费价格 **/
	private Integer riskAdviceRate;

}
