/**
 * Project Name:ssp-center-api
 * File Name:DeliveryType.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.constant
 * Date:2017年11月29日下午7:13:49
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.constant;

/**
 * 描述: 域名类型
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2018/1/25 09:37
 */
public enum DomainType {

    PUT(1, "投放域名"),
    ACTIVITY(2, "活动域名"),
    LANDING(3, "落地页域名");

    private Integer type;

    private String desc;


    DomainType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static DomainType getByType(Integer type) {
        for (DomainType e : DomainType.values()) {
            if (e.getType().equals(type)) {
                return e;
            }
        }
        return PUT;
    }

    public static String getDescByType(Integer type){
        for (DomainType e : DomainType.values()) {
            if (e.getType().equals(type)) {
                return e.getDesc();
            }
        }
        return null;
    }

}

