package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

@ApiModel
public class AppFlowRateDto implements Serializable {
    private Long id;

    @ApiModelProperty(value = "媒体id")
    private Long appId;

    @ApiModelProperty(value = "识别方式一，包名")
    private String packageName;

    @ApiModelProperty(value = "方式一消耗占比")
    private Double packageRate;

    @ApiModelProperty(value = "识别方式二，ua标签")
    private String uaLevel;

    @ApiModelProperty(value = "方式二消耗占比")
    private Double uaRate;

    @ApiModelProperty(value = "识别方式三，refer标签")
    private String referLevel;

    @ApiModelProperty(value = "识别方式三对应网址")
    private String referUrl;

    @ApiModelProperty(value = "方式三消耗占比")
    private Double referRate;

    @ApiModelProperty(value = "当前统计时间")
    private Date curDate;

    private Date gmtCreated;

    private Date gmtModified;

    @ApiModelProperty(value = "排名")
    private Integer rateTop;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName == null ? null : packageName.trim();
    }

    public Double getPackageRate() {
        return packageRate;
    }

    public void setPackageRate(Double packageRate) {
        this.packageRate = packageRate;
    }

    public String getUaLevel() {
        return uaLevel;
    }

    public void setUaLevel(String uaLevel) {
        this.uaLevel = uaLevel == null ? null : uaLevel.trim();
    }

    public Double getUaRate() {
        return uaRate;
    }

    public void setUaRate(Double uaRate) {
        this.uaRate = uaRate;
    }

    public String getReferLevel() {
        return referLevel;
    }

    public void setReferLevel(String referLevel) {
        this.referLevel = referLevel == null ? null : referLevel.trim();
    }

    public String getReferUrl() {
        return referUrl;
    }

    public void setReferUrl(String referUrl) {
        this.referUrl = referUrl == null ? null : referUrl.trim();
    }

    public Double getReferRate() {
        return referRate;
    }

    public void setReferRate(Double referRate) {
        this.referRate = referRate;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Date getGmtCreated() {
        return gmtCreated;
    }

    public void setGmtCreated(Date gmtCreated) {
        this.gmtCreated = gmtCreated;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getRateTop() {
        return rateTop;
    }

    public void setRateTop(Integer rateTop) {
        this.rateTop = rateTop;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        AppFlowRateDto other = (AppFlowRateDto) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
                && (this.getAppId() == null ? other.getAppId() == null : this.getAppId().equals(other.getAppId()))
                && (this.getPackageName() == null ? other.getPackageName() == null : this.getPackageName().equals(other.getPackageName()))
                && (this.getPackageRate() == null ? other.getPackageRate() == null : this.getPackageRate().equals(other.getPackageRate()))
                && (this.getUaLevel() == null ? other.getUaLevel() == null : this.getUaLevel().equals(other.getUaLevel()))
                && (this.getUaRate() == null ? other.getUaRate() == null : this.getUaRate().equals(other.getUaRate()))
                && (this.getReferLevel() == null ? other.getReferLevel() == null : this.getReferLevel().equals(other.getReferLevel()))
                && (this.getReferUrl() == null ? other.getReferUrl() == null : this.getReferUrl().equals(other.getReferUrl()))
                && (this.getReferRate() == null ? other.getReferRate() == null : this.getReferRate().equals(other.getReferRate()))
                && (this.getCurDate() == null ? other.getCurDate() == null : this.getCurDate().equals(other.getCurDate()))
                && (this.getGmtCreated() == null ? other.getGmtCreated() == null : this.getGmtCreated().equals(other.getGmtCreated()))
                && (this.getGmtModified() == null ? other.getGmtModified() == null : this.getGmtModified().equals(other.getGmtModified()))
                && (this.getRateTop() == null ? other.getRateTop() == null : this.getRateTop().equals(other.getRateTop()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getAppId() == null) ? 0 : getAppId().hashCode());
        result = prime * result + ((getPackageName() == null) ? 0 : getPackageName().hashCode());
        result = prime * result + ((getPackageRate() == null) ? 0 : getPackageRate().hashCode());
        result = prime * result + ((getUaLevel() == null) ? 0 : getUaLevel().hashCode());
        result = prime * result + ((getUaRate() == null) ? 0 : getUaRate().hashCode());
        result = prime * result + ((getReferLevel() == null) ? 0 : getReferLevel().hashCode());
        result = prime * result + ((getReferUrl() == null) ? 0 : getReferUrl().hashCode());
        result = prime * result + ((getReferRate() == null) ? 0 : getReferRate().hashCode());
        result = prime * result + ((getCurDate() == null) ? 0 : getCurDate().hashCode());
        result = prime * result + ((getGmtCreated() == null) ? 0 : getGmtCreated().hashCode());
        result = prime * result + ((getGmtModified() == null) ? 0 : getGmtModified().hashCode());
        result = prime * result + ((getRateTop() == null) ? 0 : getRateTop().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", appId=").append(appId);
        sb.append(", packageName=").append(packageName);
        sb.append(", packageRate=").append(packageRate);
        sb.append(", uaLevel=").append(uaLevel);
        sb.append(", uaRate=").append(uaRate);
        sb.append(", referLevel=").append(referLevel);
        sb.append(", referUrl=").append(referUrl);
        sb.append(", referRate=").append(referRate);
        sb.append(", curDate=").append(curDate);
        sb.append(", gmtCreated=").append(gmtCreated);
        sb.append(", gmtModified=").append(gmtModified);
        sb.append(", rateTop=").append(rateTop);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}