package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 风控回流建议分成价格表
 * 
 * @author YWG.MID.P
 * @date 2020-09-28 07:29:05
 */
@Data
public class SlotProposalPriceMediaShareDTO implements Serializable {

	/**
	 * 主键
	 */
		private Long id;
	/**
	 * 账号ID
	 */
	private Long mediaId;
	/**
	 * 媒体ID
	 */
	private Long appId;
	/**
	 * 广告位ID
	 */
	private Long slotId;
	/**
	 * 日期
	 */
	private Date curDate;
	/**
	 * 预期分成价格
	 */
	private Long sharedExpect;
	/**
	 * 建议分成价格
	 */
	private Long sharedSuggest;
	/**
	 * 预期每UV单价
	 */
	private Long uvPriceExpect;
	/**
	 * 建议每UV单价
	 */
	private Long uvPriceSuggest;
	/**
	 * 偏离率
	 */
	private Integer deviateRate;

	/** 是否托管 **/
	private Integer isHosting;

	/** 广告位名称 **/
	private String  slotName;

	/** 媒体名称 **/
	private String  appName;
    /**
     * 预期分成比例
     */
    private Integer divisionExpect;

    /**
     * 建议分成比例
     */
    private Integer divisionSuggest;

    /** 建议分成价格 **/
    private Long priceSuggest;

	/**
	 * 创建时间
	 */
	private Date gmtCreate;
	/**
	 * 修改时间
	 */
	private Date gmtModified;

	/** 价格（分）*/
	private Integer price;

	/** 媒体分账比例：% */
	private Integer mediaSplitRatio;

	/** 广告位有效点击PV*/
	private Long    validActClick;

	/** 广告位有效曝光PV*/
	private Long    validActExpose;

	/** 广告位曝光UV*/
	private Long slotRequestUv;

	/** 作弊消耗占比=作弊消耗/消耗*/
	private Integer cheatFeeRate;

	/** 昨日现金总消耗*/
	private Long yesterdayCashConsume;

	/**  近三日媒体uv单价均值（分）*/
	private Long avgThreeUv;

	/** 广告位有效访问PV*/
	private Long slotEfRequestPvCount;

	/** 广告位质量分 **/
	private String estimateScore;

	/** 质量等级*/
	private String estimateLevel;

	/** 建议计费价格*/
	private BigDecimal divisionPriceSuggestCal;

	/** 风控建议计费价格*/
	private String  divisionPriceSuggest;

	/** 预计昨日媒体收入*/
	private BigDecimal yesterdayExpectMediaIncomeCal;

	private Double yesterdayExpectMediaIncomeCalDouble;

	/** 预计昨日媒体收入*/
	private String yesterdayExpectMediaIncome;

	/** 建议来源.0-仅BI、1-仅风控、2-同时BI、风控*/
	private Integer suggestSource;

	/** 广告消耗（分） */
	private Long    adConsume;

	/** 合理广告消耗（分） */
	private Long    logicalConsume;

	/**
	 * 广告增值消耗（分）
	 */
	private Long valueAddedConsume;

	/** 计费方式:0-分成;1-CPC;2-CPM,3-UV单价*/
	private Integer chargeType;

	/** 平台分账比例：% . */
	private Integer platformSplitRatio;

	/** 风控建议计费价格 **/
	private Integer riskAdviceRate;


	public void initSlotBusinessData() {
		this.setValidActClick(0L);
		this.setValidActExpose(0L);
		this.setAdConsume(0L);
		this.setSlotRequestUv(0L);
		this.setLogicalConsume(0L);
		this.setYesterdayCashConsume(0L);
		this.setValueAddedConsume(0L);
	}

	/**
	 * 初始化广告位分成比例数据
	 */
	public void initSlotRatioData() {
		this.setChargeType(SlotConfigDto.CHARGE_TYPE_DIVIDED_INTO);
		this.setMediaSplitRatio(SlotConfigDto.DEFAULT_SLOT_RATIO);
		this.setPlatformSplitRatio(SlotConfigDto.DEFAULT_PLATFORM_RATIO);
		this.setPrice(SlotConfigDto.DEFAULT_PRICE);
	}



}
