package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;

import java.util.List;


@AdvancedFeignClient
public interface RemoteSlotRecommendService {

    /**
     * 新增或修改一个广告位维度的推荐位配置
     * @param req
     * @return
     */
    Boolean saveSlotRecommend(SaveSlotRecommendReq req);

    /**
     * 删除一个广告位维度的推荐位配置
     * @param id
     * @return
     */
    Boolean deleteSlotRecommend(Long id);

    /**
     * 查询一个广告位维度的推荐位配置
     * @param id
     * @return
     */
    SlotRecommendInfoDto getSlotRecommend(Long id);

    /**
     * 分页查询广告位维度的推荐位配置
     * @param req
     * @return
     */
    List<SlotRecommendInfoDto> queryList(BaseQueryDto req);

    /**
     * 总条数
     * @return
     */
    int countList();

}
