package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.UndeadLinkDto;
import cn.com.duiba.tuia.ssp.center.api.dto.UndeadLinkListReq;
import cn.com.duiba.tuia.ssp.center.api.dto.WeChatDomainItemRsp;

import java.util.List;

/**
 * 微信小程序域名服务
 */
@AdvancedFeignClient
public interface RemoteUndeadLinkService {

    /**
     * 分页查询不死链接列表
     * @return
     */
    List<UndeadLinkDto> queryLinkList(UndeadLinkListReq undeadLinkListReq);


    List<UndeadLinkDto> selectAllLink(Integer status);

    List<UndeadLinkDto> selectAllLinkBySceneType(Integer status,String sceneType);

    UndeadLinkDto popOneLink();

    UndeadLinkDto popOneLinkByScene(List<String> sceneTypes);

    /**
     * 条目数
     * @return
     */
    int countLinkList(UndeadLinkListReq undeadLinkListReq);

    /**
     * 更改不死链接状态
     * @param linkId
     * @param status
     * @return
     */
    int updateLinkStatus(Long linkId,Integer status);

    /**
     * 新增不死链接
     * @param link
     * @return
     */
    int insertUndeadLink(String link,String sceneType);

    /**
     * 根据link链接查询记录
     * @param link
     * @return
     */
    UndeadLinkDto selectByLink(String link);


    UndeadLinkDto selectByPrimaryKey(Long id);


    int updateSelective(UndeadLinkDto undeadLinkDto);

    /**
     * 获取一个不死链接 供tuia-activity-web /activity/getQrCode接口使用
     * @param slotId
     * @return
     */
    UndeadLinkDto getOneUnDeadLink(Long slotId);

    /**
     * 添加广告位到防封链接
     * @param slotId
     * @return
     */
    UndeadLinkDto addSlotToUnDeadLink(Long slotId);

    /**
     * 通过bind_slot_list字段查询
     * @return
     */
    List<UndeadLinkDto> queryBySlotId();

    /**
     * 重新绑定
     * @param slotId
     * @param oldId
     * @param newId
     * @return
     */
    Boolean reBinding(Long slotId, Long oldId, Long newId);
}
