package cn.com.duiba.tuia.ssp.center.api.dto.finaceData;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
@Getter
@Setter
public class SlotConsumeDivideBasicDiDTO implements Serializable {
    @ApiModelProperty(value = "主键")
    protected Long id;

    @ApiModelProperty(value = "创建时间")
    protected Date gmtCreate;

//    @ApiModelProperty(value = "修改时间")
//    protected Date gmtModified;

    @ApiModelProperty(value = "当天日期")
    private Date curDate;

    @ApiModelProperty(value = "媒体id")
    private Long appId;

    @ApiModelProperty(value = "广告位id")
    private Long slotId;

    @ApiModelProperty(value = "广告位曝光pv")
    private Long slotExposurePv;

    @ApiModelProperty(value = "广告位曝光uv")
    private Long slotExposureUv;

    @ApiModelProperty(value = "广告位点击pv")
    private Long slotClickPv;

    @ApiModelProperty(value = "广告位点击uv")
    private Long slotClickUv;

    @ApiModelProperty(value = "广告位访问pv")
    private Long slotVisitPv;

    @ApiModelProperty(value = "广告位访问uv")
    private Long slotVisitUv;

    @ApiModelProperty(value = "广告位访问rid滤重uv")
    private Long slotEffectVisitUv;

    @ApiModelProperty(value = "广告位访问uv-ip")
    private Long slotIpVisitUv;

    @ApiModelProperty(value = "广告位访问uv-新用户")
    private Long slotNewVisitUv;

    @ApiModelProperty(value = "活动访问pv--不含兑吧")
    private Long activityRequestPv;

    @ApiModelProperty(value = "活动访问uv--不含兑吧")
    private Long activityRequestUv;

    @ApiModelProperty(value = "活动参与pv--不含兑吧")
    private Long activityJoinPv;

    @ApiModelProperty(value = "活动参与uv--不含兑吧")
    private Long activityJoinUv;

    @ApiModelProperty(value = "券请求pv")
    private Long couponRequestPv;

    @ApiModelProperty(value = "发券pv")
    private Long launchCouponPv;

    @ApiModelProperty(value = "互动发券pv")
    private Long interactLaunchCouponPv;

    @ApiModelProperty(value = "付费券发券pv")
    private Long launchPayCouponPv;

    @ApiModelProperty(value = "免费券发券pv")
    private Long launchFreeCouponPv;

    @ApiModelProperty(value = "互动付费券发券pv")
    private Long interactLaunchPayCouponPv;

    @ApiModelProperty(value = "券曝光pv")
    private Long couponExposurePv;

    @ApiModelProperty(value = "互动券曝光pv")
    private Long interactCouponExposurePv;

    @ApiModelProperty(value = "互动付费券曝光pv")
    private Long interactCouponPayExposurePv;

    @ApiModelProperty(value = "券普通点击pv")
    private Long couponClickPv;

    @ApiModelProperty(value = "互动券普通点击pv")
    private Long interactCouponClickPv;

    @ApiModelProperty(value = "券计费点击pv")
    private Long couponEffectClickPv;
    @ApiModelProperty(value = "互动券计费点击pv")
    private Long interactCouponEffectClickPv;

    @ApiModelProperty(value = "互动付费券计费点击pv")
    private Long interactCouponPayEffectClickPv;

    @ApiModelProperty(value = "表单类券计费点击pv")
    private Long formCouponEffectClickPv;

    @ApiModelProperty(value = "互动券消耗金额(分)")
    private Long interactConsume;

    @ApiModelProperty(value = "落地页曝光pv/js落地页曝光")
    private Long landpageExposurePv;

    @ApiModelProperty(value = "表单类落地页曝光pv")
    private Long formLandpageExposurePv;

    @ApiModelProperty(value = "落地页转化pv/js落地页转化")
    private Long landpageClickPv;

    @ApiModelProperty(value = "付费券券曝光pv")
    private Long couponPayExposurePv;

    @ApiModelProperty(value = "付费券计费点击pv")
    private Long couponPayEffectClickPv;

    @ApiModelProperty(value = "业务表券消耗金额(分)")
    private Long businessConsume;

    @ApiModelProperty(value = "业务表广告现金消耗 分")
    private Long cashConsume;

    @ApiModelProperty(value = "霍尔果斯消耗比例")
    private BigDecimal hegsRate;

    @ApiModelProperty(value = "霍城兑捷消耗比例")
    private BigDecimal hcdjRate;

    /**
     * 兑推消耗比例
     */
    private BigDecimal duituiRate;

    /**
     * 券计费点击uv
     */
    private Long couponEffectClickUv;

    /**
     * 互动券请求PV
     */
    private Long interactCouponRequestPv;
}
