/**
 * Project Name:media-manager-biz
 * File Name:ReqStatHourlySort.java
 * Package Name:cn.com.duiba.tuia.media.manager.model.req
 * Date:2017年4月7日下午12:48:47
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * ClassName:ReqStatHourlySort <br/>
 * Function: 统计每小时排序. <br/>
 * Date:     2017年4月7日 下午12:48:47 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ReqStatHourlySort implements Serializable {

    private static final long serialVersionUID = 6892070876098381554L;
    /** 数据统计时间段 0:代表半小时统计一次 1:代表1小时统计一次. */
    @ApiModelProperty(value = "数据统计时间段 0:代表半小时统计一次 1:代表1小时统计一次", required = true)
    private Integer          durationType;
    
    @ApiModelProperty(value = "排序字段", required = false)
    private String          sort;
    
    /** 排序方式：(升序:asc,降序：desc)默认降序. */
    @ApiModelProperty(value = "排序方式", required = false)
    private String          order           = "desc";
    
    /** 拼接字段查询使用*/
    @ApiModelProperty(value = "拼接字段", required = false)
    private String          conditionStr;

    /** 每页记录数， 为-1时代表查询所有. */
    @ApiModelProperty(value = "每页记录数", required = false)
    private Integer         pageSize;

    /** 管理员ID，数据权限使用*/
    @ApiModelProperty(value = "管理员ID", required = false)
    private Long            managerId;

    /** 管理员能查看的app列表*/
    @ApiModelProperty(value = "管理员ID", required = false)
    private List<Long> managerAppIds;

    /** 管理员能查看的用户列表*/
    @ApiModelProperty(value = "用户ID集合", required = false)
    private List<Long>      managerMediaIds;
    
    public Integer getDurationType() {
		return durationType;
	}

	public void setDurationType(Integer durationType) {
		this.durationType = durationType;
	}
    
    public String getSort() {
        return sort;
    }

    
    public void setSort(String sort) {
        this.sort = sort;
    }

    
    public String getOrder() {
        return order;
    }

    
    public void setOrder(String order) {
        this.order = order;
    }

    
    public String getConditionStr() {
        return conditionStr;
    }

    
    public void setConditionStr(String conditionStr) {
        this.conditionStr = conditionStr;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Long getManagerId() {
        return managerId;
    }

    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }

    public List<Long> getManagerAppIds() {
        return managerAppIds;
    }

    public void setManagerAppIds(List<Long> managerAppIds) {
        this.managerAppIds = managerAppIds;
    }

    public List<Long> getManagerMediaIds() {
        return managerMediaIds;
    }

    public void setManagerMediaIds(List<Long> managerMediaIds) {
        this.managerMediaIds = managerMediaIds;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}

