package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.ssp.center.api.dto.IpAreaLibraryDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteIpAreaLibraryService {

    /**
     * 查询所有数据
     *
     * @return 所有ip
     */
    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="30000")
    List<IpAreaLibraryDto> selectAll();
}
