package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 结算单
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ReqSettled extends BaseQueryDto {

    private static final long serialVersionUID = -8544802493261012411L;

    /**
     * 	账号ID
     */
    private Long mediaId;

    /**
     * 账户名称
     */
    private String mediaName;

    /**
     * 开始日期
     */
    private Date startDate;

    /**
     * 结束日期
     */
    private Date endDate;

    /**
     * 审核状态（0:驳回 1:待财务审核 2:审核通过）
     */
    private Integer checkStatus;

    /**
     * 公司主体（0：杭推 1：霍推 2：兑捷）
     * @see cn.com.duiba.tuia.ssp.center.api.constant.TuiaCompanyType
     */
    private Integer companyType;

    /**
     * 结算单号
     */
    private String settlementId;

    /**
     * 账户 Id 集合
     */
    @JsonIgnore
    private List<Long> mediaIds;

}
