package cn.com.duiba.tuia.ssp.center.api.constant.ocpx;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2022/4/11
 * @Description 媒体节点枚举
 * @Param
 * @return
 **/
@Getter
public enum MediaTypeEnum {
    /************************************************快手subType类型***********************************************************************/
    KUAISHOU_PHONE(1, "1", "激活"),
    KUAISHOU_FORM(1, "2", "注册"),
    KUAISHOU_VIEW(1, "3", "付费"),
    KUAISHOU_ACTIVE(1, "5", "活跃"),
    KUAISHOU_ACTIVE_REGISTER(1, "6", "优质用户"),
    KUAISHOU_ACTIVE_PAY(1, "7", "次日留存"),
    KUAISHOU_CONSULT_EFFECTIVE(1, "9", "表单"),
    KUAISHOU_IN_APP_ORDER(1, "10", "完件"),
    KUAISHOU_IN_APP_PAY(1, "11", "授信"),
    KUAISHOU_GAME_ADDICTION(1, "44", "有效线索"),
    KUAISHOU_CUSTOMER_EFFECTIVE(1, "84", "唤起应用"),
    KUAISHOU_COUPON(1, "109", "电话卡激活"),
    KUAISHOU_NEXT_DAY_OPEN(1, "117", "意向确认"),
    KUAISHOU_SHOPPING(1, "118", "微信加粉"),
    KUAISHOU_LOAN_COMPLETION(1, "119", "成交"),
    KUAISHOU_SUBMIT_ORDER(1, "14", "提交订单"),

    /************************************************广点通subType类型***********************************************************************/

    GAUNGDAINTONG_RESERVATION(10, "RESERVATION", "预约"),
    GAUNGDAINTONG_CONFIRM_EFFECTIVE_LEADS(10, "CONFIRM_EFFECTIVE_LEADS", "有效综合线索"),
    GAUNGDAINTONG_ACTIVATE_APP(10, "ACTIVATE_APP", "激活"),
    GAUNGDAINTONG_START_APP(10, "START_APP", "次日留存"),
    GAUNGDAINTONG_REGISTER(10, "REGISTER", "注册"),
    GAUNGDAINTONG_PURCHASE(10, "PURCHASE", "付费"),
    GAUNGDAINTONG_COMPLETE_ORDER(10, "COMPLETE_ORDER", "下单"),
    GAUNGDAINTONG_APPLY(10, "APPLY", "完件"),
    GAUNGDAINTONG_PRE_CREDIT(10, "PRE_CREDIT", "预授信"),
    GAUNGDAINTONG_CREDIT(10, "CREDIT", "授信"),


    /************************************************百度subType类型***********************************************************************/

    BAIDU_CONSULT_BUTTON_CLICK(2, "1", "咨询按钮点击"),
    BAIDU_PHONE_CLICK(2, "2", "电话按钮点击"),
    BAIDU_FORM_SUBMIT(2, "3", "表单提交成功"),
    BAIDU_ACTIVATION(2, "4", "激活"),
    BAIDU_FORM_BUTTON_CLICK(2, "5", "表单按钮点击"),
    BAIDU_DOWNLOAD_BUTTON_CLICK(2, "6", "下载按钮点击"),
    BAIDU_BUY_BUTTON_CLICK(2, "7", "购买按钮点击(支付按钮点击)"),
    BAIDU_APPOINTMENT_BUTTON_CLICK(2, "12", "预约按钮点击"),
    BAIDU_FORM_VALID_REQUEST(2, "13", " 表单有效请求"),
    BAIDU_SECOND_ECOMMERCE_ORDER_SUBMIT(2, "14", "二类电商订单提交成功"),
    BAIDU_SINGLE_TABLE_CALL_UP_BUTTON_CLICK(2, "16", "表单调起按钮点击"),
    BAIDU_EFFECTIVE_CLUES(2, "18", "有效线索"),
    BAIDU_APP_REGISTRATION(2, "25", "应用注册"),
    BAIDU_PAY(2, "26", "付费"),
    BAIDU_SERVICE_PURCHASE_SUCCESS(2, "10", "服务购买成功"),
    BAIDU_CUSTOM(2, "27", "客户自定义"),


    /************************************************巨量subType类型***********************************************************************/
    JULIANG_PHONE(8, "phone", "电话拨打"),
    JULIANG_FORM(8, "form", "表单提交"),
    JULIANG_VIEW(8, "view", "关键页面浏览"),
    JULIANG_ACTIVE(8, "active", "激活"),
    JULIANG_ACTIVE_REGISTER(8, "active_register", "注册"),
    JULIANG_ACTIVE_PAY(8, "active_pay", "付费"),
    JULIANG_CONSULT_EFFECTIVE(8, "consult_effective", "有效咨询"),
    JULIANG_IN_APP_ORDER(8, "in_app_order", "app内下单"),
    JULIANG_IN_APP_PAY(8, "in_app_pay", "app内付费"),
    JULIANG_GAME_ADDICTION(8, "game_addiction", "关键行为"),
    JULIANG_CUSTOMER_EFFECTIVE(8, "customer_effective", "有效获客"),
    JULIANG_COUPON(8, "coupon", "卡券领取"),
    JULIANG_NEXT_DAY_OPEN(8, "next_day_open", "次留"),
    JULIANG_SHOPPING(8, "shopping", "商品购买"),
    JULIANG_LOAN_COMPLETION(8, "loan_completion", "完件"),
    JULIANG_LOAN_CREDIT(8, "loan_credit", "授信"),
    JULIANG_CLUE_FORMAL_ORDER(8, "clue_formal_order", "线索-正式成单"),
    JULIANG_SUPPLY_ACTIVE_PAY(8, "supply_active_pay", "付费-新"),


    /************************************************趣头条subType类型***********************************************************************/
    QUTOUTIAO_SUBMIT_FORM(3, "26", "提交表单"),
    QUTOUTIAO_PAY(3, "31", "表单付费"),
    QUTOUTIAO_OTHERS(3, "27", "其他"),
    QUTOUTIAO_CONSULATION(3, "28", "有效咨询"),
    QUTOUTIAO_LANDING_PAGE_JUMP(3, "29", "落地页跳转"),


    /************************************************喜马拉雅subType类型***********************************************************************/
    XIMALAYA_SUBMIT_FORM(17, "2", "表单提交"),
    XIMALAYA_PAY(17, "7", "支付-存在意向"),
    XIMALAYA_VISIT(17, "8", "回访-信息确认"),
    XIMALAYA_CONSULATION(17, "3", "有效咨询"),
    XIMALAYA_OTHERS(17, "6", "其他"),


    /************************************************爱奇艺subType类型***********************************************************************/
    IQIYI_SUBMIT_FORM(4, "200", "表单提交"),
    IQIYI_DETAIL(4, "201", "查看详情"),
    IQIYI_CREDIT(4, "210", "授信"),
    IQIYI_ACTIVATION(4, "0", "激活"),
    IQIYI_REGISTER(4, "1", "注册"),
    IQIYI_FIRST_PAYMENT(4, "2", "首次付费"),
    IQIYI_RETAINED(4, "3", "次日留存"),


    /************************************************B站subType类型***********************************************************************/
    BLIBLI_APP_DOWNLOAD(9, "APP_DOWNLOAD", "APP下载成功"),
    BLIBLI_APP_INSTALL(9, "APP_INSTALL", "APP安装成功"),
    BLIBLI_APP_FIRST_ACTIVE(9, "APP_FIRST_ACTIVE", "APP首次激活"),
    BLIBLI_FORM_SUBMIT(9, "FORM_SUBMIT", "表单提交"),
    BLIBLI_USER_REGISTER(9, "USER_REGISTER", "用户注册"),
    BLIBLI_ADD_TO_CART(9, "ADD_TO_CART", "加入购物车"),
    BLIBLI_ORDER_PLACE(9, "ORDER_PLACE", "提交订单"),
    BLIBLI_USER_COST(9, "USER_COST", "完成付费行为"),
    BLIBLI_USER_RESERVE(9, "USER_RESERVE", "用户参与某个活动预订"),
    BLIBLI_RETENTION(9, "RETENTION", "用户留存"),
    BLIBLI_APP_CALLUP(9, "APP_CALLUP", "调起成功"),
    BLIBLI_FORM_USER_COST(9, "FORM_USER_COST", "教育完成表单付费行为"),


    /************************************************VIVO subType类型***********************************************************************/
    VIVO_ACTIVATION(15, "ACTIVATION", "激活"),
    VIVO_REGISTER(15, "REGISTER", "注册"),
    VIVO_PAY(15, "PAY", "付费"),
    VIVO_SUBMIT(15, "SUBMIT", "表单提交"),
    VIVO_WEBPAY(15, "WEBPAY", "网页购买"),
    VIVO_RETENTION_1(15, "RETENTION_1", "次日留存"),
    VIVO_CALL(15, "CALL", "拨打电话"),
    VIVO_REACTIVATION(15, "REACTIVATION", "拉活"),
    VIVO_ADD_SCREEN(15, "ADD_SCREEN", "快应用加桌"),
    VIVO_BUTTON_CLICK(15, "BUTTON_CLICK", "按钮点击"),
    VIVO_OTHER(15, "OTHER", "其他"),


    /************************************************UC subType类型***********************************************************************/
    UC_ACTIVATION(16, "1", "激活"),
    UC_FORM_SUBMIT(16, "5", "表单提交"),
    UC_REGISTER_WEB(16, "12", "注册(网页类)"),
    UC_REGISTER(16, "27", "注册(应用类)"),
    UC_ORDER(16, "11", "下单购买"),
    UC_PAY(16, "1000", "付费"),
    UC_RETENTION(16, "1001", "次日留存"),
    UC_WECHAT_FOCUS(16, "65", "微信关注"),
    UC_WECHAT_PAY(16, "66", "微信付费"),
    UC_ADD_SCREEN(16, "68", "快应用加桌"),
    UC_PAY_SCREEN(16, "69", "快应用付费"),
    UC_CALL_UP(16, "50", "调起"),
    UC_VISIT_PRODUCT_DETAILS(16, "51", "访问商品详情"),
    UC_COLLECT_CARD_AND_COUPON(16, "53", "领取卡券"),


    /************************************************wifi万能钥匙 subType类型***********************************************************************/
    WN_WIFI_ACTIVATION(18, "1", "激活事件"),
    WN_WIFI_REGISTER(18, "2", "注册事件"),
    WN_WIFI_PAY(18, "3", "付费事件"),
    WN_WIFI_RETENTION(18, "5", "次日留存"),
    WN_WIFI_ADDICTION(18, "6", "关键行为"),
    WN_WIFI_18DAY_REACTIVATION(18, "7", "18天拉活"),
    WN_WIFI_30DAY_REACTIVATION(18, "8", "30天拉活"),
    WN_WIFI_SUBMIT(18, "10", "表单提交"),


    /************************************************360 subType类型***********************************************************************/
    API360_SUBMIT(19, "SUBMIT", "表单提交"),
    API360_CALL(19, "CALL", "电话拨打"),
    API360_ADVISORY(19, "ADVISORY", "咨询"),

    /************************************************soul subType类型***********************************************************************/
    SOUL_FORM_SUBMIT(20, "form", "表单提交"),
    SOUL_SHOPPING(20, "shopping", "商品购买"),
    SOUL_CONSULT_EFFECTIVE(20, "consult_effective", "有效咨询"),
    SOUL_CUSTOMER_EFFECTIVE(20, "customer_effective", "有效获客"),
    SOUL_PHONE(20, "phone", "电话拨打"),
    SOUL_PAGE_VIEW(20, "page_view", "页面访问"),
    SOUL_OTHER_H5(20, "other_h5", "落地页-其他"),
    SOUL_ACTIVE_PAY_H5(20, "active_pay_h5", "付费-落地页"),
    SOUL_GAME_ADDICTION_H5(20, "game_addiction_h5", "关键行为-落地页"),
    SOUL_CLUE_FORMAL_ORDER(20, "clue_formal_order", "线索-正式成单"),


    /************************************************xiaomi subType类型***********************************************************************/
    WEB_FORM_SUBMIT(21, "WEB_FORM_SUBMIT", "表单提交"),
    WEB_CARD_ACTIVE(21, "WEB_CARD_ACTIVE", "通信激活"),
    WEB_DETAIL_OPEN(21, "WEB_DETAIL_OPEN", "H5商详页打开"),
    WEB_LOGIN(21, "WEB_LOGIN", "登录"),
    WEB_ADD_CART(21, "WEB_ADD_CART", "加购"),
    WEB_CONFIRM_ORDER(21, "WEB_CONFIRM_ORDER", "订单确认"),
    WEB_SUBMIT_ORDER(21, "WEB_SUBMIT_ORDER", "订单提交"),
    WEB_COMPLETE_ORDER(21, "WEB_COMPLETE_ORDER", "下单"),
    H5_PURCHASE(21, "H5_PURCHASE", "H5购买"),


    /************************************************微博 subType类型***********************************************************************/
    WEIBO_FORM_SUBMIT(22, "1001", "表单提交"),
    WEIBO_CALL(22, "1002", "电话拨打"),
    WEIBO_CONSULT_EFFECTIVE(22, "1003", "有效咨询"),

    /************************************************OPPO subType类型***********************************************************************/
    OPPO_FORM_SUBMIT(23, "101", "表单提交"),
    OPPO_KET_BEHAVIOR(23, "102", "表单关键行为"),
    OPPO_CONSULT_EFFECTIVE(23, "103", "表单-有效咨询"),
    OPPO_WECHAT_FOCUS(23, "104", "表单-微信关注"),
    OPPO_WEBPAY(23, "105", "表单-网页购买"),
    OPPO_PHONE(23, "106", "表单-电话拨打"),

    /************************************************Weimob subType类型***********************************************************************/
    WEIMOB_FINISH_SUBMIT(24, "finish_submit", "完成提交"),
    WEIMOB_START_SUBMIT(24, "start_submit", "开始提交"),
    WEIMOB_FORM_SUBMIT(24, "form_submit", "提交表单"),
    WEIMOB_LOGIN(24, "login", "登录"),
    WEIMOB_REGISTER(24, "register", "注册"),
    WEIMOB_FINISH_CHECKOUT(24, "finish_checkout", "用户完成支付"),
    WEIMOB_INITIATE_CHECKOUT(24, "initiate_checkout", "用户发起支付"),
    WEIMOB_ADD_PAYMENTINFO(24, "add_paymentinfo", "用户添加付款信息"),
    WEIMOB_ADD_DELIVERYINFO(24, "add_deliveryinfo", "添加收件地址"),
    WEIMOB_PURCHASE(24, "purchase", "付费"),
    WEIMOB_ADD_CART(24, "add_cart", "加入购物车"),
    WEIMOB_ADD_WISH(24, "add_wish", "加入收藏夹"),
    WEIMOB_PAGESDETAIL_FINISH_LOADING(24, "pagesdetail_finish_loading", "详情页加载完成"),
    WEIMOB_PAGESDETAIL_START_LOADING(24, "pagesdetail_start_loading", "详情页开始加载"),
    WEIMOB_SEARCH_FINISH_LOADING(24, "search_finish_loading", "搜索加载完成"),
    WEIMOB_SEARCH_START_LOADING(24, "search_start_loading", "搜索开始加载"),
    WEIMOB_SEARCH(24, "search", "搜索"),
    WEIMOB_PAGESITE_FINISH_LOADING(24, "pagesite_finish_loading", "落地页加载完成"),

    /************************************************SouHu subType类型***********************************************************************/
    SOHU_PHONE(25, "2001", "电话拨打"),
    SOHU_FROM_SUBMIT(25, "2002", "表单提交"),
    SOHU_BUTTON_CLICK(25, "2003", "按钮点击"),
    SOHU_BUY(25, "2008", "购买"),
    SOHU_CONSULT_EFFECTIVE(25, "2013", "咨询"),
    SOHU_KEY_BEHAVIOR(25, "2015", "网页关键行为"),

    /************************************************科大讯飞 subType类型***********************************************************************/
    IFLYTEK_ARRIVE(26, "1", "到达"),
    IFLYTEK_INTERACTIVE(26, "2", "互动"),
    IFLYTEK_PURCHASE(26, "3", "付费"),
    IFLYTEK_REGISTER(26, "4", "注册"),
    IFLYTEK_RETENTION(26, "5", "留存"),

    /************************************************华为 subType类型***********************************************************************/
    HUA_WEI_Adds_TO_CART(27, "Adds to cart", "Adds to cart"),
    HUA_WEI_Orders(27, "Orders", "Orders"),
    HUA_WEI_Buy(27, "Buy", "Buy"),
    HUA_WEI_Favorites(27, "Favorites", "Favorites"),
    HUA_WEI_Payment(27, "Payment", "Payment"),
    HUA_WEI_View_CART(27, "View cart", "View cart"),
    HUA_WEI_LOG_IN(27, "Log-in", "Log-in"),
    HUA_WEI_SIGN_IN(27, "Sign-in", "Sign-in"),
    HUA_WEI_Browsing(27, "Browsing", "Browsing"),
    HUA_WEI_Download(27, "Download", "Download"),
    HUA_WEI_Install(27, "Install", "Install"),
    HUA_WEI_Active(27, "Active", "Active"),
    HUA_WEI_Registration(27, "Registration", "Registration"),
    HUA_WEI_Recharge(27, "Recharge", "Recharge"),
    HUA_WEI_UserLead(27, "UserLead", "UserLead"),

    /****************************************** 网易有道 subType 类型 ***************************************/
    YOUDAO_LANDINGPAGE_SUBMITFORM(28, "landingpage_submitform", "表单提交"),
    YOUDAO_LANDINGPAGE_DIAL(28, "landingpage_dial", "电话拨打"),
    YOUDAO_LANDINGPAGE_WECHATCOPY(28, "landingpage_wechatcopy", "微信复制"),
    YOUDAO_LANDINGPAGE_DOWNLOAD(28, "landingpage_download", "开始下载"),
    YOUDAO_LANDINGPAGE_KEYPV(28, "landingpage_keypv", "关键页面访问"),
    YOUDAO_LANDINGPAGE_REGISTER(28, "landingpage_register", "注册"),
    YOUDAO_LANDINGPAGE_ADDTOCART(28, "landingpage_addtocart", "加入购物车"),
    YOUDAO_LANDINGPAGE_PURCHASE(28, "landingpage_purchase", "购买"),
    YOUDAO_LANDINGPAGE_SUBMITCREDIT(28, "landingpage_submitcredit", "完件"),
    YOUDAO_LANGDINGPAGE_PRECREDIT(28, "langdingpage_precredit", "预授信"),
    YOUDAO_LANDINGPAGE_CREDIT(28, "landingpage_credit", "授信"),
    YOUDAO_LANDINGPAGE_CUSTOMBUTTON(28, "landingpage_custombutton", "自定义行为"),


    /****************************************** 软告 subType 类型 ***************************************/
    RUANGAO_CALL_UP(29, "1", "呼起"),
    RUANGAO_REGISTER(29, "2", "注册"),
    RUANGAO_ACTIVATION(29, "3", "激活"),
    RUANGAO_CREATE_ROLE(29, "4", "创角"),
    RUANGAO_LOGIN(29, "5", "新登"),
    RUANGAO_DOWNLOAD(29, "6", "下载"),
    RUANGAO_INSTALL(29, "7", "安装"),
    RUANGAO_SECOND_JUMP(29, "8", "二跳"),
    RUANGAO_PAY(29, "9", "购买"),
    RUANGAO_OTHER(29, "10", "其他"),


    /****************************************** 网易易效 conv_type 类型 ***************************************/
    WANGYIYIXIAO_ACTIVED(30, "actived", "激活"),
    WANGYIYIXIAO_REGISTER(30, "register", "注册"),
    WANGYIYIXIAO_COMMIT_MSG(30, "commit_msg", "授信"),
    WANGYIYIXIAO_PAY(30, "pay", "付费"),
    WANGYIYIXIAO_RETAINED(30, "retained", "次日留存"),
    WANGYIYIXIAO_PHONE(30, "phone", "拨打电话"),
    WANGYIYIXIAO_SUBMIT(30, "submit", "表单提交"),
    WANGYIYIXIAO_CONSULT(30, "consult", "有效咨询"),
    WANGYIYIXIAO_WXCOPY(30, "wxcopy", "微信复制"),
    WANGYIYIXIAO_DOWNLOAD(30, "download", "应用下载"),
    WANGYIYIXIAO_VISIT(30, "visit", "页面访问"),
    WANGYIYIXIAO_BUY(30, "buy", "购买"),
    WANGYIYIXIAO_OTHER(30, "other", "其他"),

    /************************************************360 搜索subType类型***********************************************************************/
    SEARCH_360_SUBMIT(31, "SUBMIT", "表单提交"),
    SEARCH_API360_CALL(31, "CALL", "有效电话拨打"),
    SEARCH_API360_ADVISORY(31, "ADVISORY", "一句话咨询"),
    SEARCH_API360_SITEDOWNLOAD(31, "SITEDOWNLOAD", "下载按钮点击"),
    SEARCH_API360_SUBMIT_BUTTON(31, "SUBMIT_BUTTON", "表单按钮点击"),
    SEARCH_API360_ADVISORY_BUTTON(31, "ADVISORY_BUTTON", "咨询按钮点击"),
    SEARCH_API360_CALL_BUTTON(31, "CALL_BUTTON", "电话按钮点击"),
    SEARCH_API360_SHOP_BUTTON(31, "SHOP_BUTTON", "购买按钮点击"),
    SEARCH_API360_CART_BUTTON(31, "CART_BUTTON", "加入购物车按钮点击"),
    SEARCH_API360_ORDER(31, "ORDER", "订单"),
    SEARCH_API360_REGISTERED(31, "REGISTERED", "注册"),
    SEARCH_API360_ROLE_CREAT(31, "ROLE_CREAT", "创建角色"),
    SEARCH_API360_SITE_VISIT_DEPTH(31, "SITE_VISIT_DEPTH", "深度页面访问"),
    SEARCH_API360_COUSTOMIZE(31, "COUSTOMIZE", "客户自定义"),

    /************************************************360 展示 qsubType类型***********************************************************************/
    DISPLAY_360_SUBMIT(32, "SUBMIT", "线索转化"),
    DISPLAY_API360_CALL(32, "CALL", "有效电话转化"),
    DISPLAY_API360_ADVISORY(32, "ADVISORY", "咨询转化"),
    DISPLAY_API360_ORDER(32, "ORDER", "订单转化"),
    DISPLAY_API360_REGISTERED(32, "REGISTERED", "注册转化"),
    DISPLAY_API360_ROLE_CREAT(32, "ROLE_CREAT", "创建角色转化"),
    DISPLAY_API360_COUSTOMIZE(32, "COUSTOMIZE", "自定义转化"),
    DISPLAY_API360_MIDDLE_PAGE(32, "MIDDLE_PAGE", "中间页"),

    /***********************************************    Sigmob ********************************************************************************/
//    SIGMOB_ACTIVE(33,"active","应用安装后打开事件"),
//    SIGMOB_REGISTER(33,"register","注册事件"),
//    SIGMOB_LOGIN(33,"login","登录事件（用于计算留存）"),
//    SIGMOB_PAY(33,"pay","付费事件"),
//    SIGMOB_QUALITY_USER(33,"quality_user","价值用户"),
//    SIGMOB_CANCELLATION(33,"cancellation","订单取消/退订"),
    SIGMOB_ACTIVE(33,"no","无媒体节点"),

    /************************************************  新浪subType类型  ***********************************************************************/
    SINA_OTHER(ProgrammaticMediaPlatformEnum.SINA.getPlatform(), "0", "其他"),

    /************************************************  多盟subType类型  ***********************************************************************/
    DOMOB_BEHAVIOR(35, "100", "⻚面关键互动行为"),
    DOMOB_FORM_SUBMIT(35, "101", "线索表单提交"),
    DOMOB_ORDER_SUBMIT(35, "102", "用戶订单提交"),

    /************************************************  优酷subType类型  ***********************************************************************/
    YOUKU_DOWNLOAD(36, "download", "下载"),
    YOUKU_INSTALL(36, "install", "安装"),
    YOUKU_REGISTER(36, "register", "注册"),
    YOUKU_FIRST_ACTIVE(36, "first_active", "首次激活"),
    YOUKU_ACTIVE(36, "active", "激活"),
    YOUKU_LOGIN(36, "login", "登录"),
    YOUKU_PAY(36, "pay", "付费"),
    YOUKU_RENEW_PAY(36, "renew_pay", "历史续费"),
    YOUKU_VISIT(36, "visit", "到访"),
    YOUKU_FORM_SUBMIT(36, "form_submit", "表单提交"),

    /************************************************  百度联盟subType类型  ***********************************************************************/
    BAIDU_ALLIANCE_FORM_SUBMIT(37, "3", "表单提交成功"),
    BAIDU_ALLIANCE_FORM_CLICK(37, "5", "表单按钮点击"),
    BAIDU_ALLIANCE_FORM_VAILD_REQUEST(37, "13", "表单有效请求"),
    BAIDU_ALLIANCE_FORM_PULL_UP_CLICKE(37, "16", "表单调起按钮点击"),
    BAIDU_ALLIANCE_APP_UP(37, "71", "应用调起"),

    /************************************************  凤凰网subType类型  ***********************************************************************/
    FENGHUANG_BUY(38, "0", "购买"),
    FENGHUANG_FORM_SUBMIT(38, "1", "表单提交"),
    FENGHUANG_EFFECT_CUSTOMERS(38, "2", "有效获客"),

    /************************************************  凤凰网subType类型  ***********************************************************************/
    JULIANG_SBS_PAY(39, "2", "付费"),
    JULIANG_SBS_FORM(39, "3", "表单"),
    JULIANG_SBS_EFFECTIVE_CONSULTATION(39, "5", "有效咨询"),
    JULIANG_SBS_PHONE(39, "7", "电话拨打"),
    JULIANG_SBS_EFFECTIVE_CUSTOMER_ACQUIRE(39, "19", "有效获客"),
    JULIANG_SBS_CONFIRM(39, "194", "回访_信息确认"),
    JULIANG_SBS_ADD_FRIEND(39, "195", "回访_加为好友"),
    JULIANG_SBS_TRANSACTIONS(39, "196", "回访_高潜成交"),
    JULIANG_SBS_PAY_EXIST_INTENTION(39, "218", "支付_存在意向"),
    JULIANG_SBS_ADD_WECHAT(39, "386", "微信_添加企业微信"),
    JULIANG_SBS_CANCEL_FRIEND(39, "396", "企业微信_取消好友"),

    /************************************************  七猫类型  ***********************************************************************/
    QIMAO_APP_CALLUP(40, "3001", "调起成功"),
    QIMAO_APP_ACTIVATE(40, "3002", "APP激活"),
    QIMAO_USER_COST(40, "3003", "付费行为"),
    QIMAO_FORM_SUBMIT(40, "3004", "表单行为"),
    QIMAO_RETAINED(40, "3005", "次日留存"),
    QIMAO_KET_BEHAVIOR(40, "3006", "关键行为"),
    QIMAO_REGISTER(40, "3007", "注册行为"),
    QIMAO_COMPLETE_ORDER(40, "3008", "下单"),
    QIMAO_CALL(40, "3009", "电话咨询"),
    QIMAO_ADD_TO_CART(40, "3010", "加入购物车"),

    /************************************************  白菜（被猪🐷拱了）  ***********************************************************************/

    BAICAI_SUBMIT(41, "1", "表单提交"),
    BAICAI_ACTIVATE(41, "3", "激活"),
    BAICAI_REGISTRY(41, "4", "注册"),
    BAICAI_PAY(41, "5", "付费"),
    BAICAI_ORDER(41, "6", "下单"),
    BAICAI_CREDIT(41, "10", "授信"),
    BAICAI_REFUND(41, "24", "退款"),

    /************************************************  灯火（把你眼照瞎）  ***********************************************************************/
    LIGHT_TRADE(42, "215", "小程序交易笔数"),
    LIGHT_PAGE_VISIT(42, "225", "小程序页面浏览"),
    LIGHT_PAGE_SUBMIT(42, "425", "留资表单提交"),
    LIGHT_COLLECT(42, "219", "小程序收藏(API回传)"),

    /************************************************  华为（黑夜给了我黑色眼睛）  ***********************************************************************/
    HUAWEI_JINGHONG_REGISTER(43, "register", "注册"),
    HUAWEI_JINGHONG_RETAIN(43, "retain", "次留"),
    HUAWEI_JINGHONG_PAID(43, "paid", "付费"),
    HUAWEI_JINGHONG_PREORDER(43, "preOrder", "下单"),
    HUAWEI_JINGHONG_ORDERSIGNING(43, "orderSigning", "订单签收"),
    HUAWEI_JINGHONG_FIRSTPURCHASE(43, "firstPurchase", "首次购买"),
    HUAWEI_JINGHONG_REENGAGE(43, "reEngage", "用户唤醒"),
    HUAWEI_JINGHONG_FORM_SUBMIT(43, "form_submit", "表单提交"),

    /************************************************  荣耀  ***********************************************************************/
    HONOR_10001(44, "10001", "激活"),
    HONOR_10002(44, "10002", "注册"),
    HONOR_10003(44, "10003", "次留"),
    HONOR_10004(44, "10004", "付费"),
    HONOR_10007(44, "10007", "下单"),
    HONOR_10016(44, "10016", "订单签收"),
    HONOR_10017(44, "10017", "首次购买"),
    HONOR_10022(44, "10022", "用户唤醒"),

    /************************************************  推啊  ***********************************************************************/
    TUIA_LANDING_PAGE_CONVERSIONS(45, "0", "落地页转化"),
    /**
     * 安装
     */
    TUIA_INSTALL(45, "1", "安装 APP"),
    /**
     * 启动
     */
    TUIA_START_UP(45, "2", "启动 APP"),
    /**
     * 注册
     */
    TUIA_REGISTER(45, "3", "注册账号"),
    /**
     * 激活
     */
    TUIA_ACTIVATION(45, "4", "激活账号"),
    /**
     * 登录
     */
    TUIA_LOG_IN(45, "5", "登录账号"),
    /**
     * 付费
     */
    TUIA_PAY(45, "6", "用户付费"),
    /**
     * 进件
     */
    TUIA_INCOMING(45, "7", "用户进件"),
    /**
     * 完件
     */
    TUIA_COMPLETE(45, "8", "用户完件"),
    /**
     * 签收
     */
    TUIA_SIGN_FOR_RECEIPT(45, "9", "用户签收"),
    /**
     * 拒签
     */
    TUIA_VISA_REFUSAL(45, "10", "用户拒签"),

    /************************************************  小红书  ***********************************************************************/
    XIAOHONGSHU_SUBMIT(46, "101", "表单提交"),
    XIAOHONGSHU_VALID_SUBMIT(46, "102", "有效表单"),
    XIAOHONGSHU_PHONE_CALL(46, "111", "电话拨打"),
    XIAOHONGSHU_PHONE_CONNECT(46, "112", "电话接通"),
    XIAOHONGSHU_WX_COPY(46, "121", "微信复制"),
    XIAOHONGSHU_WX_ADD_FRIENT(46, "122", "微信加好友"),
    XIAOHONGSHU_NEGATIVE_SAMPLE(46, "200", "负向样本"),
    XIAOHONGSHU_IDENTITY_AUTHENTICATION (46, "131", "身份认证"),
    XIAOHONGSHU_PAY(46, "141", "付费"),

    FACAISHU(47, "no", " 无")

    ;
    private Integer platform;

    private String mediaType;

    private String desc;

    MediaTypeEnum(Integer platform, String mediaType, String desc) {
        this.platform = platform;
        this.mediaType = mediaType;
        this.desc = desc;
    }
}
