package cn.com.duiba.tuia.ssp.center.api.dto.appDailyProfit;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * 联盟媒体每日利润
 */
@Data
@ApiModel
public class UnionAppDailyProfitDto extends BaseAppDailyProfitDto {
    /** 序列号 */
    private static final long serialVersionUID = -3323315628443058575L;

    @ApiModelProperty(value = "媒体id", required = false)
    private Long              appId;

    @ApiModelProperty(value = "媒体名称", required = false)
    private String            appName;

    @ApiModelProperty(value = "媒体消耗", required = false)
    private Long              appConsume;

    @ApiModelProperty(value = "uv消耗", required = false)
    private Long              uvConsume;

    public static UnionAppDailyProfitDto calculateUnionCashSharing(UnionAppDailyProfitDto unionAppDailyProfitDto) {

        Double cashRate = 1.06D;
        Long divisor = 10000L;
        // 广告消耗单位：分。现金分成比例是小数后4位，乘以10000保存。

        //分成：根据公式进行计算，计算公式：现金分成/1.06。单位不用转
        Long consumeSharing = new BigDecimal(unionAppDailyProfitDto.getCashSharing()).divide(new BigDecimal(cashRate),0,BigDecimal.ROUND_HALF_UP).longValue();

        //现金广告消耗：根据公式进行计算，计算公式：广告消耗/1.06。单位是分不转换
        Long advertCashConsume = new BigDecimal(unionAppDailyProfitDto.getAdvertConsume()).divide(new BigDecimal(cashRate),0,BigDecimal.ROUND_HALF_UP).longValue();

        //媒体消耗：根据分成进行计算，计算公式：广告消耗*分成。分成是乘以10000保存，结果需要除以10000
        Long appConsume = new BigDecimal(unionAppDailyProfitDto.getAdvertConsume()).multiply(new BigDecimal(consumeSharing)).divide(new BigDecimal(divisor),0,BigDecimal.ROUND_HALF_UP).longValue();

        //日利润：根据公式进行计算，计算公式：现金广告消耗-媒体消耗
        Long dailyProfit = advertCashConsume-appConsume;

        unionAppDailyProfitDto.setConsumeSharing(consumeSharing);
        unionAppDailyProfitDto.setAdvertCashConsume(advertCashConsume);
        unionAppDailyProfitDto.setAppConsume(appConsume);
        unionAppDailyProfitDto.setDailyProfit(dailyProfit);
        unionAppDailyProfitDto.setDataType(0);
        return unionAppDailyProfitDto;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
