package cn.com.duiba.tuia.ssp.center.api.dto.cpa;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created by hong
 * time 2024/6/26.
 */
@Data
public class CpaDailyProfitDataDto extends BaseQueryDto {
    private static final long serialVersionUID = 1L;

    /**
     * 现金结算收入
     */
    private BigDecimal cashIncome;

    /**
     * 现金利润
     */
    private BigDecimal cashProfit;

    /**
     * 日期
     */
    private Date curDate;

    /**
     * 开始日期
     */
    private Date startDate;

    /**
     * 结束日期
     */
    private Date endDate;

    /**
     * 每日利润
     */
    private BigDecimal dailyProfit;

    /**
     * 备注
     */
    private String dataDesc;

    /**
     * 0:未确认，1:已确认
     */
    private Integer dataType;

    /**
     * 买量支出
     */
    private BigDecimal expenses;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * id
     */
    private Long id;

    /**
     * 媒体返点
     */
    private BigDecimal mediaRebate;

    /**
     * 运营id
     */
    private Long operatorId;

    /**
     * 运营名称
     */
    private String operatorName;

    /**
     * 平台ID
     */
    private Long platformId;

    /**
     * 平台名称
     */
    private String platformName;

    /**
     * 产品id
     */
    private Long productId;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 核减比例
     */
    private BigDecimal reductionRatio;

    /**
     * 结算收入
     */
    private BigDecimal settlementIncome;

    /**
     * 运营id集合
     */
    private List<Long> operatorIds;


}
