package cn.com.duiba.tuia.ssp.center.api.dto.monthreport;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author fangzhipeng
 * @date 2018/9/20
 */
public class ConsumeVisitData implements Serializable, GetSetDate {

    private static final long serialVersionUID = 8202397074327337965L;

    /**
     * 日期 yyyy-MM-dd 格式
     */
    private String date;

    /**
     * 收益
     */
    private Long consumeTotal = 0L;

    /**
     * 每UV收益
     */
    private Long mediaActUvPrice = 0L;

    /**
     * 广告位访问pv
     */
    private Long slotRequestPv = 0L;

    /**
     * 广告位访问uv
     */
    private Long slotRequestUv = 0L;

    public ConsumeVisitData() {}

    public ConsumeVisitData(String date, Long consumeTotal, Long slotRequestPv, Long slotRequestUv) {
        this.date = date;
        this.consumeTotal = consumeTotal;
        this.slotRequestPv = slotRequestPv;
        this.slotRequestUv = slotRequestUv;
        this.mediaActUvPrice = calculateAveragePrice(consumeTotal, slotRequestUv);
    }

    public ConsumeVisitData merge(ConsumeVisitData other) {
        this.consumeTotal = this.consumeTotal + other.getConsumeTotal();
        this.slotRequestPv = this.slotRequestPv + other.getSlotRequestPv();
        this.slotRequestUv = this.slotRequestUv + other.getSlotRequestUv();
        this.mediaActUvPrice = calculateAveragePrice(this.consumeTotal, this.slotRequestUv);
        return this;
    }

    /**
     * 计算点击均价.
     *
     * @param divisor  分子
     * @param dividend 分母
     * @return the integer
     */
    public static Long calculateAveragePrice(Long divisor, Long dividend) {
        Long result = null;
        if (dividend != null && divisor != null && divisor.longValue() != 0 && dividend.longValue() != 0) {
            BigDecimal bigDivisor = new BigDecimal(divisor);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.divide(bigDividend, BigDecimal.ROUND_HALF_UP).longValue();
        }
        return result;
    }

    @Override
    public String getDate() {
        return date;
    }

    @Override
    public void setDate(String date) {
        this.date = date;
    }

    public Long getConsumeTotal() {
        return consumeTotal;
    }

    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    public Long getMediaActUvPrice() {
        return mediaActUvPrice;
    }

    public void setMediaActUvPrice(Long mediaActUvPrice) {
        this.mediaActUvPrice = mediaActUvPrice;
    }

    public Long getSlotRequestPv() {
        return slotRequestPv;
    }

    public void setSlotRequestPv(Long slotRequestPv) {
        this.slotRequestPv = slotRequestPv;
    }

    public Long getSlotRequestUv() {
        return slotRequestUv;
    }

    public void setSlotRequestUv(Long slotRequestUv) {
        this.slotRequestUv = slotRequestUv;
    }

}
