package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ManagerShieldStrategyDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqDuibaSlotDto;

import java.util.List;

/**
 * 兑吧对接广告位屏蔽标签专用接口
 * 需求地址：http://cf.dui88.com/pages/viewpage.action?pageId=7694704
 */
@AdvancedFeignClient
public interface RemoteSlot4Duiba {

    /**
     * 创建广告位
     *
     * 由于兑吧广告位数据对于推啊没有业务意义，仅需要广告位id关联屏蔽标签，故现有广告位表不需要保存
     * 该接口创建的广告位数据，因此执行插入默认广告位数据获取id（主键），再将本条数据删除来获取自增主键，
     * 并保证主键不冲突
     * 
     * @param reqDuibaSlotDto 创建兑吧广告位参数
     * ReqDuibaSlotDto:{
     *     'appId' : 兑吧媒体应用id<必填/>.
     *     'slotName' : 兑吧广告位名称<必填/>.
     * }
     * 
     * @return 广告位ID (返回-1时为异常场景，请特殊处理)
     */
    Long createSlot4Duiba(ReqDuibaSlotDto reqDuibaSlotDto);

    /**
     * 批量查询广告位屏蔽标签
     *
     * @param slotIds 广告位ID列表<必填,单次查询上限100个广告位/>
     * @return ManagerShieldStrategyDto 广告位屏蔽标签对象
     * ManagerShieldStrategyDto:{
     *     'slotId' : 广告位id
     *     'shieldUrls' : 屏蔽广告主URL列表， 中间以逗号隔开，对应页面‘广告主url屏蔽’.
     *     'shieldIndustries' : 屏蔽行业列表，中间以逗号隔开，对应页面‘行业屏蔽’.
     *     'advertTagNums' : 屏蔽广告列表，中间以逗号隔开，对应页面‘标签屏蔽’.
     * }
     */
    List<ManagerShieldStrategyDto> listMSSDtos4Duiba(List<Long> slotIds);

    /**
     * 批量更新广告位屏蔽标签
     * 先删除再插入列表中所有广告位ID对应的屏蔽策略
     * 同时更新redis中的广告位屏蔽策略数据供广告平台调用
     * @param mssDtos 屏蔽策略<单次最多插入100条数据/>
     * ManagerShieldStrategyDto:{
     *     'slotId' : 广告位id<必填/>
     *     'shieldUrls' : 屏蔽广告主URL列表， 中间以逗号隔开，对应页面‘广告主url屏蔽’.
     *     'shieldIndustries' : 屏蔽行业列表，中间以逗号隔开，对应页面‘行业屏蔽’.
     *     'advertTagNums' : 屏蔽广告列表，中间以逗号隔开，对应页面‘标签屏蔽’.
     * }
     * @return 插入行数
     */
    Integer updateMSS4Duiba(List<ManagerShieldStrategyDto> mssDtos);

}
