package cn.com.duiba.tuia.ssp.center.api.dto.newMedia;

import cn.com.duiba.tuia.ssp.center.api.constant.enums.NewMediaSlotImportEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class NewMediaDTO implements Serializable {

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 媒体id
     */
    private Long appId;

    /**
     * 媒体名称
     */
    private String appName;

    /**
     * 广告位id
     */
    private Long slotId;

    /**
     * 广告位名称
     */
    private String slotName;

    /**
     * 广告位是否加入冷启动
     */
    private Integer isColdStart;

    /**
     * 流量突破比例
     */
    private Integer flowBreakoutRatio;

    /**
     * 主运营id
     */
    private Long mainManagerId;

    /**
     * 主运营名字
     */
    private String mainManagerName;

    /**
     * 导入时间
     */
    private Date importTime;

    /**
     * 移除时间
     */
    private Date removeTime;

    /**
     * 移除周期
     */
    private Integer removePeriod;

    /**
     * 导入类型
     *
     * @see NewMediaSlotImportEnum#name()
     */
    private String importType;

    /**
     * 是否删除
     */
    private Integer isDeleted;
}
