package cn.com.duiba.tuia.ssp.center.api.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 素材文件类型
 *
 * @author zhangzhenghe
 * @since 2020-04-24 3:36 PM
 */
@Getter
@AllArgsConstructor
public enum FileTypeEnum {

    IMG_JPG("jpg"),

    IMG_JPEG("jpeg"),

    IMG_PNG("png"),

    IMG_GIF("gif"),

    VIDEO_MP4("mp4"),

    SVGA("svga"),
    ;

    private String type;

    public static Set<String> getAllTypes() {
        return Arrays.stream(FileTypeEnum.values()).map(FileTypeEnum::getType).collect(Collectors.toSet());
    }
}
