package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.Date;
import java.util.List;

/**
 * 通知（站内信）媒体关联DTO
 *
 * @author songjiaxing
 *
 */
public class NoticeMediaDto extends BaseDto {

	private static final long serialVersionUID = 1249514959920892723L;

	private List<Long> idList;

	/**
	 * 媒体id
	 */
	private Long mediaId;

	/**
	 * 通知id
	 */
	private Long noticeId;

	/**
	 * 读取状态（0：接收未读，1：接收已读）阅读uv
	 */
	private Integer readStatus;

	/**
	 * 删除状态（0：未删除，1：已删除）
	 */
	private Integer isDelete;

	/**
	 * 发送时间
	 */
	private Date sendTime;

	/**
	 * 阅读pv
	 */
	private Long readPv;

	/**
	 * 消息类型:1-媒体线通知;2-火眼数据通知;3-广告线通知;4-实验平台通知;5-分控通知;6-其他
	 */
	private Integer messageType;
	/**
	 * 平台:1-媒体后台;2-媒体管理后台
	 */
	private Integer platform;

	public Integer getMessageType() {
		return messageType;
	}

	public void setMessageType(Integer messageType) {
		this.messageType = messageType;
	}

	public Integer getPlatform() {
		return platform;
	}

	public void setPlatform(Integer platform) {
		this.platform = platform;
	}

	public List<Long> getIdList() {
		return idList;
	}

	public void setIdList(List<Long> idList) {
		this.idList = idList;
	}

	public Long getReadPv() {
		return readPv;
	}

	public void setReadPv(Long readPv) {
		this.readPv = readPv;
	}

	public Long getMediaId() {
		return mediaId;
	}

	public void setMediaId(Long mediaId) {
		this.mediaId = mediaId;
	}

	public Long getNoticeId() {
		return noticeId;
	}

	public void setNoticeId(Long noticeId) {
		this.noticeId = noticeId;
	}

	public Integer getReadStatus() {
		return readStatus;
	}

	public void setReadStatus(Integer readStatus) {
		this.readStatus = readStatus;
	}

	public Integer getIsDelete() {
		return isDelete;
	}

	public void setIsDelete(Integer isDelete) {
		this.isDelete = isDelete;
	}


	public Date getSendTime() {
		return sendTime;
	}


	public void setSendTime(Date sendTime) {
		this.sendTime = sendTime;
	}

}
