/**
 * Project Name:media-api File Name:RspDataStatistics.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2016年10月11日下午2:27:11 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:RspDataStatistics <br/>
 * Function: 结算数据统计. <br/>
 * Date: 2016年10月11日 下午2:27:11 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class RspSlotLineStatisticsDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 2902137581196740720L;

    /** 当前日期 */
    private List<String>      curDate;
    /** 点击数. */
    private List<Long>        clickCount;
    /** 曝光量. */
    private List<Long>        exposureCount;
    /**
     * 广告券曝光量.
     */
    private List<Long>        advertExposureCount;
    /**
     * 广告券Cpm.
     */
    private List<Long>        advertCpm;
    /** 每一千次的有效价格. */
    private List<Long>        eCpm;
    /** 预计收入. */
    private List<Long>        consumeTotal;
    /** 点击率 */
    private List<Float>       clickRate;
    /**广告位访问pv*/
    private List<Long>        slotRequestPv;
    /**广告位访问uv*/
    private List<Long>        slotRequestUv;
    /**每点击收益*/
    private List<Long>        mediaCpc;
    /**千次展示收益*/
    private List<Long>        mediaCpm;
    /**每UV收益*/
    private List<Long> mediaUvPrice;
    /**
     * 次日留存
     */
    private List<Float> morrowRetention;
    /**
     * 三日留存
     */
    private List<Float> threeDaysRetention;

    /**
     * 七日留存
     */
    private List<Float> sevenDaysRetention;
    /**
     * 三日ltv
     */
    private List<Float> threeDaysLtv;

    /**
     * 活动访问
     */
    private List<Long> activityParticipationUv;
    /**
     * 活动参与率
     */
    private List<Float> participationRate;


    private List<Long> newRequestUvCount;

    /**
     *  历史收益峰值
     */
    private Long maxConsumerTotal;
    /**
     *  历史曝光量峰值
     */
    private Long maxExposureCount;
    /**
     *  历史eCPM峰值
     */
    private Long maxEcpm;
    /**
     *  历史点击量峰值
     */
    private Long maxClickCount;
    /**
     *  历史点击率峰值
     */
    private Float maxClickRate;

    /**
     *  历史每 uv 收益峰值
     */
    private Long maxMediaUvPrice;

    /**
     *  历史广告位访问uv峰值
     */
    private Long maxSlotRequestUv;

    public Long getMaxMediaUvPrice() {
        return maxMediaUvPrice;
    }

    public void setMaxMediaUvPrice(Long maxMediaUvPrice) {
        this.maxMediaUvPrice = maxMediaUvPrice;
    }

    public Long getMaxSlotRequestUv() {
        return maxSlotRequestUv;
    }

    public void setMaxSlotRequestUv(Long maxSlotRequestUv) {
        this.maxSlotRequestUv = maxSlotRequestUv;
    }

    public Long getMaxExposureCount() {
        return maxExposureCount;
    }

    public void setMaxExposureCount(Long maxExposureCount) {
        this.maxExposureCount = maxExposureCount;
    }

    public Long getMaxEcpm() {
        return maxEcpm;
    }

    public void setMaxEcpm(Long maxEcpm) {
        this.maxEcpm = maxEcpm;
    }

    public Long getMaxClickCount() {
        return maxClickCount;
    }

    public void setMaxClickCount(Long maxClickCount) {
        this.maxClickCount = maxClickCount;
    }

    public Float getMaxClickRate() {
        return maxClickRate;
    }

    public void setMaxClickRate(Float maxClickRate) {
        this.maxClickRate = maxClickRate;
    }

    public Long getMaxConsumerTotal() {
        return maxConsumerTotal;
    }

    public void setMaxConsumerTotal(Long maxConsumerTotal) {
        this.maxConsumerTotal = maxConsumerTotal;
    }

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.6
     */
    public List<String> getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.6
     */
    public void setCurDate(List<String> curDate) {
        this.curDate = curDate;
    }

    /**
     * clickCount.
     *
     * @return the clickCount
     * @since JDK 1.6
     */
    public List<Long> getClickCount() {
        return clickCount;
    }

    /**
     * clickCount.
     *
     * @param clickCount the clickCount to set
     * @since JDK 1.6
     */
    public void setClickCount(List<Long> clickCount) {
        this.clickCount = clickCount;
    }

    /**
     * exposureCount.
     *
     * @return the exposureCount
     * @since JDK 1.6
     */
    public List<Long> getExposureCount() {
        return exposureCount;
    }

    /**
     * exposureCount.
     *
     * @param exposureCount the exposureCount to set
     * @since JDK 1.6
     */
    public void setExposureCount(List<Long> exposureCount) {
        this.exposureCount = exposureCount;
    }

    public List<Long> getAdvertExposureCount() {
        return advertExposureCount;
    }

    public void setAdvertExposureCount(List<Long> advertExposureCount) {
        this.advertExposureCount = advertExposureCount;
    }

    public List<Long> getAdvertCpm() {
        return advertCpm;
    }

    public void setAdvertCpm(List<Long> advertCpm) {
        this.advertCpm = advertCpm;
    }

    /**
     * eCpm.
     *
     * @return the eCpm
     * @since JDK 1.6
     */
    public List<Long> geteCpm() {
        return eCpm;
    }

    /**
     * eCpm.
     *
     * @param eCpm the eCpm to set
     * @since JDK 1.6
     */
    public void seteCpm(List<Long> eCpm) {
        this.eCpm = eCpm;
    }

    /**
     * consumeTotal.
     *
     * @return the consumeTotal
     * @since JDK 1.6
     */
    public List<Long> getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * consumeTotal.
     *
     * @param consumeTotal the consumeTotal to set
     * @since JDK 1.6
     */
    public void setConsumeTotal(List<Long> consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * clickRate.
     *
     * @return the clickRate
     * @since JDK 1.6
     */
    public List<Float> getClickRate() {
        return clickRate;
    }

    /**
     * clickRate.
     *
     * @param clickRate the clickRate to set
     * @since JDK 1.6
     */
    public void setClickRate(List<Float> clickRate) {
        this.clickRate = clickRate;
    }
    
    /**
     * slotRequestPv.
     *
     * @return the slotRequestPv
     */
    public List<Long> getSlotRequestPv() {
        return slotRequestPv;
    }

    /**
     * slotRequestPv.
     *
     * @param slotRequestPv the slotRequestPv to set
     */
    public void setSlotRequestPv(List<Long> slotRequestPv) {
        this.slotRequestPv = slotRequestPv;
    }

    /**
     * slotRequestUv.
     *
     * @return the slotRequestUv
     */
    public List<Long> getSlotRequestUv() {
        return slotRequestUv;
    }

    /**
     * slotRequestUv.
     *
     * @param slotRequestUv the slotRequestUv to set
     */
    public void setSlotRequestUv(List<Long> slotRequestUv) {
        this.slotRequestUv = slotRequestUv;
    }

    public List<Long> getMediaCpc() {
        return mediaCpc;
    }

    public void setMediaCpc(List<Long> mediaCpc) {
        this.mediaCpc = mediaCpc;
    }

    public List<Long> getMediaCpm() {
        return mediaCpm;
    }

    public void setMediaCpm(List<Long> mediaCpm) {
        this.mediaCpm = mediaCpm;
    }

    public List<Long> getMediaUvPrice() {
        return mediaUvPrice;
    }

    public void setMediaUvPrice(List<Long> mediaUvPrice) {
        this.mediaUvPrice = mediaUvPrice;
    }

    public List<Float> getMorrowRetention() {
        return morrowRetention;
    }

    public void setMorrowRetention(List<Float> morrowRetention) {
        this.morrowRetention = morrowRetention;
    }

    public List<Float> getThreeDaysRetention() {
        return threeDaysRetention;
    }

    public void setThreeDaysRetention(List<Float> threeDaysRetention) {
        this.threeDaysRetention = threeDaysRetention;
    }

    public List<Float> getSevenDaysRetention() {
        return sevenDaysRetention;
    }

    public void setSevenDaysRetention(List<Float> sevenDaysRetention) {
        this.sevenDaysRetention = sevenDaysRetention;
    }

    public List<Float> getThreeDaysLtv() {
        return threeDaysLtv;
    }

    public void setThreeDaysLtv(List<Float> threeDaysLtv) {
        this.threeDaysLtv = threeDaysLtv;
    }

    public List<Long> getActivityParticipationUv() {
        return activityParticipationUv;
    }

    public void setActivityParticipationUv(List<Long> activityParticipationUv) {
        this.activityParticipationUv = activityParticipationUv;
    }

    public List<Float> getParticipationRate() {
        return participationRate;
    }

    public void setParticipationRate(List<Float> participationRate) {
        this.participationRate = participationRate;
    }

    public List<Long> getNewRequestUvCount() {
        return newRequestUvCount;
    }

    public void setNewRequestUvCount(List<Long> newRequestUvCount) {
        this.newRequestUvCount = newRequestUvCount;
    }

    /**
     * 初始化lsit
     *
     * @param dto
     * @param initSize
     * @return
     */
    public RspSlotLineStatisticsDto initList(RspSlotLineStatisticsDto dto,Integer initSize){
        dto.setClickCount(new ArrayList<>(initSize));
        dto.setCurDate(new ArrayList<>(initSize));
        dto.setClickRate(new ArrayList<>(initSize));
        dto.setSlotRequestPv(new ArrayList<>(initSize));
        dto.setSlotRequestUv(new ArrayList<>(initSize));
        dto.seteCpm(new ArrayList<>(initSize));
        dto.setConsumeTotal(new ArrayList<>(initSize));
        dto.setExposureCount(new ArrayList<>(initSize));
        dto.setAdvertExposureCount(new ArrayList<>(initSize));
        dto.setAdvertCpm(new ArrayList<>(initSize));
        dto.setMediaUvPrice(new ArrayList<>(initSize));
        dto.setMediaCpc(new ArrayList<>(initSize));
        dto.setMediaCpm(new ArrayList<>(initSize));
        dto.setMorrowRetention(new ArrayList<>(initSize));
        dto.setThreeDaysRetention(new ArrayList<>());
        dto.setSevenDaysRetention(new ArrayList<>());
        dto.setThreeDaysLtv(new ArrayList<>());
        dto.setActivityParticipationUv(new ArrayList<>());
        dto.setParticipationRate(new ArrayList<>());
        dto.setNewRequestUvCount(new ArrayList<>());
        return dto;
    }

    /**
     * set param
     *
     * @param dto
     * @return
     */
    public RspSlotLineStatisticsDto setListParam(RspSlotLineStatisticsDto dto){
        dto.setClickCount(dto.getClickCount());
        dto.setCurDate(dto.getCurDate());
        dto.setClickRate(dto.getClickRate());
        dto.setSlotRequestPv(dto.getSlotRequestPv());
        dto.setSlotRequestUv(dto.getSlotRequestUv());
        dto.seteCpm(dto.geteCpm());
        dto.setConsumeTotal(dto.getConsumeTotal());
        dto.setExposureCount(dto.getExposureCount());
        dto.setMediaUvPrice(dto.getMediaUvPrice());
        dto.setMediaCpc(dto.getMediaCpc());
        dto.setMediaCpm(dto.getMediaCpm());
        dto.setActivityParticipationUv(dto.getActivityParticipationUv());
        dto.setParticipationRate(dto.getParticipationRate());
        dto.setMorrowRetention(dto.getMorrowRetention());
        dto.setThreeDaysRetention(dto.getThreeDaysRetention());
        dto.setSevenDaysRetention(dto.getSevenDaysRetention());
        dto.setThreeDaysLtv(dto.getThreeDaysLtv());
        dto.setNewRequestUvCount(dto.getNewRequestUvCount());
        return dto;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
