package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * 广告位活动统计
 *
 * @author zhangzhenghe
 * @since 2020-02-19 4:52 PM
 */
@Data
public class SlotActivityProblemsStatisticsDTO implements Serializable {

    private static final long serialVersionUID = 3240646697587087414L;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 日均变现效率（10000倍率）
     */
    private Long dailyMonetizeRate;

    /**
     * 日均cvr（10000倍率）
     */
    private Long dailyCvr;

    /**
     * 日均访问uv
     */
    private Long dailyAccessUv;

    /**
     * 广告位平均变现效率（10000倍率）
     */
    private Long slotAverageMonetizeRate;

    /**
     * 广告位日均访问uv
     */
    private Long slotAverageAccessUv;

    /**
     * 广告位日均cvr（10000倍率）
     */
    private Long slotAverageCvr;

    /**
     * 活动投放周期
     */
    private Long servingDay;

    /**
     * 变现效率走势（10000倍率）
     */
    private Long monetizeTrend;

    /**
     * 变现效率降低幅度（10000倍率）
     */
    private Long monetizeDownRate;
}
