package cn.com.duiba.tuia.ssp.center.api.dto.externalplatformmedia;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class ExternalPlatformMediaDataSnapshotDTO implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 账号id
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 媒体标识符
     */
    private Integer mediaType;

    /**
     * 账号名称
     */
    private String accountName;

    /**
     * 媒体消耗
     */
    private BigDecimal mediaConsume;

    /**
     * 入口素材曝光数
     */
    private Long entryMaterialExposureCount;

    /**
     * 入口素材点击数
     */
    private Long entryMaterialClickCount;

    /**
     * 运营人员
     */
    private String operatorName;

    /**
     * 运营人员id
     */
    private Long operatorId;

    /**
     * 广告位id
     */
    private String slotId;

    /**
     * 是否删除:0.未删除 1.已删除
     */
    private Integer isDelete;

    /**
     * 代理名称
     */
    private String agentName;

    /**
     * 子账号
     */
    private String childrenId;

    /**
     * 媒体id
     */
    private Long appId;

}
