package cn.com.duiba.tuia.ssp.center.api.params;

import cn.com.duiba.tuia.ssp.center.api.annotation.FieldCheck;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author K. L. Mao
 * @create 2019-12-11
 */
@Data
public class FileCollectShieldParam implements Serializable {

    /**
     *  手机品牌
     */
    @FieldCheck(notEmpty = true)
    private String phoneBrand;

    /**
     *  手机型号
     */
    @FieldCheck(notEmpty = true)
    private String phoneType;

    public void toLowerCase(){
        this.phoneBrand = StringUtils.lowerCase(phoneBrand);
        this.phoneType = StringUtils.lowerCase(phoneType);
    }
}
