package cn.com.duiba.tuia.ssp.center.api.params;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;

import java.io.Serializable;
import java.util.Date;

/**
* 运营商程序化媒体上报配置表
*/
public class OperatorMediaReportConfigParam extends BaseQueryDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
    * 主键
    */
    private Long id;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
    * 上报策略表ID
    */
    private Long reportStrategyId;

    /**
    * 删除标识 0-否 1-是
    */
    private Integer isDeleted;

    /**
    * 上报维度 1-全局维度 2- 广告资源维度 3-广告维度
    */
    private Integer reportDimension;

    /**
    * 资源ID
    */
    private String tagId;

    /**
    * 计划ID
    */
    private Long advertId;

    /**
    * 推啊上报节点
    */
    private Integer tuiaType;

    /**
    * 媒体上报节点
    */
    private String mediaType;

    /**
    * 回传概率
    */
    private Integer returnProbability;

    /**
    * 运营商id tb_telecom_operator
    */
    private Long operatorId;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setReportStrategyId(Long reportStrategyId) {
        this.reportStrategyId = reportStrategyId;
    }

    public Long getReportStrategyId() {
        return reportStrategyId;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public Integer getIsDeleted() {
        return isDeleted;
    }

    public void setReportDimension(Integer reportDimension) {
        this.reportDimension = reportDimension;
    }

    public Integer getReportDimension() {
        return reportDimension;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public String getTagId() {
        return tagId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setTuiaType(Integer tuiaType) {
        this.tuiaType = tuiaType;
    }

    public Integer getTuiaType() {
        return tuiaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaType() {
        return mediaType;
    }

    public void setReturnProbability(Integer returnProbability) {
        this.returnProbability = returnProbability;
    }

    public Integer getReturnProbability() {
        return returnProbability;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public Long getOperatorId() {
        return operatorId;
    }

}

