package cn.com.duiba.tuia.ssp.center.api.remote.advertselect.context;

import cn.com.duiba.tuia.ssp.center.api.remote.advertselect.dto.context.AdvertSelectContextDto;
import com.alibaba.ttl.TransmittableThreadLocal;

import java.util.Objects;

/**
 *广告互选上下文，为了嵌套层级太深的方法，并没有封装成对象的方法，传参采用上下文的方式
 *
 * 优点：写的很爽。
 *
 */
public class AdvertSelectContext {

    /** TransmittableThreadLocal可以在父子线程中传递. */
    private static final TransmittableThreadLocal<AdvertSelectContextDto> local = new TransmittableThreadLocal<>();

    private static class Holder {
        private static AdvertSelectContext context = new AdvertSelectContext();
    }

    /**
     * The Constructor.
     */
    private AdvertSelectContext() {

    }

    public static AdvertSelectContext getContext() {
        return Holder.context;
    }

    /**
     * @return
     */
    public AdvertSelectContextDto get() {
        if (Objects.isNull(local.get())) {
            return new AdvertSelectContextDto();
        }
        return local.get();

    }

    /**
     * @param dto
     */
    public void set(AdvertSelectContextDto dto) {
        local.set(dto);
    }
}
