package cn.com.duiba.tuia.ssp.center.api.remote.sdk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.Result;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.*;
import cn.com.duiba.tuia.ssp.center.api.query.SdkAggreCrashLogQuery;
import cn.com.duiba.tuia.ssp.center.api.query.SdkCrashLogQuery;

import java.util.List;

/**
 * @author K. L. Mao
 * @create 2019-12-30
 */
@AdvancedFeignClient
public interface RemoteSdkCrashLogService {

    /**
     * 插入崩溃日志
     * @param sdkCrashLogDTO
     * @return
     */
    Result<Void> insertSdkCrashLog(SdkCrashLogDTO sdkCrashLogDTO);

    /**
     * 崩溃日志列表
     * @param crashLogQuery
     * @return
     */
    Result<PageResultDto<SdkCrashLogDTO>> listSdkCrashLog(SdkCrashLogQuery crashLogQuery);

    /**
     * 崩溃日志聚合列表
     * @param crashLogQuery
     * @return
     */
    Result<PageResultDto<SdkAggreCrashLogDTO>> listAggreSdkCrashLog(SdkCrashLogQuery crashLogQuery);

    /**
     * 崩溃日志
     * @param crashLogQuery
     * @return
     */
    Result<SdkAggreCrashLogDTO> aggreSdkCrashLog(SdkAggreCrashLogQuery crashLogQuery);

    /**
     *  聚合版本信息
     * @param crashLogQuery
     * @return
     */
    Result<PageResultDto<SdkVersionAggreDTO>> listAggreSdkVersion(SdkAggreCrashLogQuery crashLogQuery);

    /**
     *  聚合机型信息
     * @param crashLogQuery
     * @return
     */
    Result<PageResultDto<SdkModeDeviceAggreDTO>> listAggreSdkModeDevice(SdkAggreCrashLogQuery crashLogQuery);

    /**
     *  聚合操作系统信息
     * @param crashLogQuery
     * @return
     */
    Result<PageResultDto<SdkOsInfoAggreDTO>> listAggreSdkOsInfo(SdkAggreCrashLogQuery crashLogQuery);

    /**
     *  查看更多记录
     * @param crashLogQuery
     * @return
     */
    Result<PageResultDto<SdkCrashLogDTO>> listSdkCrashLogByIds(SdkAggreCrashLogQuery crashLogQuery);

    /**
     * 已解决操作
     * @param sdkLogId
     * @return
     */
    Result<Void> resolveAction(Long sdkLogId);

    /**
     * 已解决操作
     * @param sdkLogId
     * @return
     */
    Result<Void> resolveActionV2(List<Long> sdkLogIds,Integer status);

    /**
     * 崩溃日志详情
     * @param sdkLogId
     * @return
     */
    Result<SdkCrashLogDetailDTO> sdkCrashLogDetail(Long sdkLogId);

    /**
     * 异常概述
     * @param crashLogQuery
     * @return
     */
    Result<SdkCrashOverviewDTO> overview(SdkCrashLogQuery crashLogQuery);

}
